/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreSearcher;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNormalisingKeyFileStore
implements FileStore<String>,
FileStoreSearcher<String> {
    private final PathKeyFileStore delegate;

    public PathNormalisingKeyFileStore(File baseDir) {
        this(new PathKeyFileStore(baseDir));
    }

    public PathNormalisingKeyFileStore(PathKeyFileStore delegate) {
        this.delegate = delegate;
    }

    public LocallyAvailableResource move(String key, File source) {
        return this.delegate.move(this.normalizePath(key), source);
    }

    public LocallyAvailableResource copy(String key, File source) {
        return this.delegate.copy(key, source);
    }

    protected String normalizePath(String path) {
        return path.replaceAll("[^\\d\\w\\./]", "_");
    }

    protected String normalizeSearchPath(String path) {
        return path.replaceAll("[^\\d\\w\\.\\*/]", "_");
    }

    public void moveFilestore(File destination) {
        this.delegate.moveFilestore(destination);
    }

    public LocallyAvailableResource add(String key, Action<File> addAction) {
        return this.delegate.add(this.normalizePath(key), addAction);
    }

    public Set<? extends LocallyAvailableResource> search(String key) {
        return this.delegate.search(this.normalizeSearchPath(key));
    }
}

