/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.GenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.AbstractTaskPropertyBuilder;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputPropertySpecAndBuilder;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.api.tasks.TaskInputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputPropertySpec
extends AbstractTaskPropertyBuilder
implements TaskInputPropertySpecAndBuilder {
    private final TaskPropertyFileCollection files;
    private boolean skipWhenEmpty;
    private boolean optional;
    private SnapshotNormalizationStrategy snapshotNormalizationStrategy = TaskFilePropertySnapshotNormalizationStrategy.ABSOLUTE;
    private Class<? extends FileCollectionSnapshotter> snapshotter = GenericFileCollectionSnapshotter.class;

    public DefaultTaskInputPropertySpec(String taskName, FileResolver resolver, Object paths) {
        this.files = new TaskPropertyFileCollection(taskName, "input", this, resolver, paths);
    }

    @Override
    public FileCollection getPropertyFiles() {
        return this.files;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPropertyName(String propertyName) {
        this.setPropertyName(propertyName);
        return this;
    }

    @Override
    public boolean isSkipWhenEmpty() {
        return this.skipWhenEmpty;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty(boolean skipWhenEmpty) {
        this.skipWhenEmpty = skipWhenEmpty;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty() {
        return this.skipWhenEmpty(true);
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional() {
        return this.optional(true);
    }

    @Override
    public TaskFilePropertyCompareStrategy getCompareStrategy() {
        return TaskFilePropertyCompareStrategy.UNORDERED;
    }

    @Override
    public SnapshotNormalizationStrategy getSnapshotNormalizationStrategy() {
        return this.snapshotNormalizationStrategy;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPathSensitivity(PathSensitivity sensitivity) {
        return this.withSnapshotNormalizationStrategy(TaskFilePropertySnapshotNormalizationStrategy.valueOf(sensitivity));
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withSnapshotNormalizationStrategy(SnapshotNormalizationStrategy snapshotNormalizationStrategy) {
        this.snapshotNormalizationStrategy = snapshotNormalizationStrategy;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withSnapshotter(Class<? extends FileCollectionSnapshotter> snapshotter) {
        this.snapshotter = snapshotter;
        return this;
    }

    @Override
    public Class<? extends FileCollectionSnapshotter> getSnapshotter() {
        return this.snapshotter;
    }

    @Override
    public String toString() {
        return this.getPropertyName() + " (" + this.snapshotNormalizationStrategy + ")";
    }

    private UnsupportedOperationException failWithUnsupportedMethod(String method) {
        throw new UnsupportedOperationException(String.format("Chaining of the TaskInputs.%s method is not supported since Gradle 4.0.", method));
    }

    @Override
    public boolean getHasInputs() {
        throw this.failWithUnsupportedMethod("getHasInputs()");
    }

    @Override
    public FileCollection getFiles() {
        throw this.failWithUnsupportedMethod("getFiles()");
    }

    @Override
    public TaskInputFilePropertyBuilder files(Object ... paths) {
        throw this.failWithUnsupportedMethod("files(Object...)");
    }

    @Override
    public TaskInputFilePropertyBuilder file(Object path) {
        throw this.failWithUnsupportedMethod("file(Object)");
    }

    @Override
    public TaskInputFilePropertyBuilder dir(Object dirPath) {
        throw this.failWithUnsupportedMethod("dir(Object)");
    }

    @Override
    public Map<String, Object> getProperties() {
        throw this.failWithUnsupportedMethod("getProperties()");
    }

    @Override
    public TaskInputs property(String name, Object value) {
        throw this.failWithUnsupportedMethod("property(String, Object)");
    }

    @Override
    public TaskInputs properties(Map<String, ?> properties) {
        throw this.failWithUnsupportedMethod("properties(Map)");
    }

    @Override
    public boolean getHasSourceFiles() {
        throw this.failWithUnsupportedMethod("getHasSourceFiles()");
    }

    @Override
    public FileCollection getSourceFiles() {
        throw this.failWithUnsupportedMethod("getSourceFiles()");
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }
}

