/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.provider.DefaultPropertyState;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProviderFactory
implements ProviderFactory {
    @Override
    public <T> Provider<T> provider(Callable<T> value) {
        if (value == null) {
            throw new InvalidUserDataException("Value cannot be null");
        }
        return new DefaultProvider<T>(value);
    }

    @Override
    public <T> PropertyState<T> property(Class<T> clazz) {
        if (clazz == null) {
            throw new InvalidUserDataException("Class cannot be null");
        }
        DefaultPropertyState<Comparable<Boolean>> propertyState = new DefaultPropertyState<Comparable<Boolean>>();
        if (clazz == Boolean.class) {
            propertyState.set(Boolean.FALSE);
        } else if (clazz == Byte.class) {
            propertyState.set(Byte.valueOf((byte)0));
        } else if (clazz == Short.class) {
            propertyState.set(Short.valueOf((short)0));
        } else if (clazz == Integer.class) {
            propertyState.set(Integer.valueOf(0));
        } else if (clazz == Long.class) {
            propertyState.set(Long.valueOf(0L));
        } else if (clazz == Float.class) {
            propertyState.set(Float.valueOf(0.0f));
        } else if (clazz == Double.class) {
            propertyState.set(Double.valueOf(0.0));
        } else if (clazz == Character.class) {
            propertyState.set(new Character('\u0000'));
        }
        return propertyState;
    }
}

