/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.project.taskfactory.DestroysPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NestedBeanPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NoOpPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoriesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OverridingPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskClassValidationMessage;
import org.gradle.api.internal.project.taskfactory.TaskClassValidator;
import org.gradle.api.internal.project.taskfactory.TaskClassValidatorExtractor;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.TaskPropertyInfo;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.internal.tasks.options.OptionValues;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.internal.reflect.GroovyMethods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskClassValidatorExtractor
implements TaskClassValidatorExtractor {
    private static final Collection<Class<?>> IGNORED_SUPER_CLASSES = ImmutableSet.of(ConventionTask.class, DefaultTask.class, AbstractTask.class, Task.class, Object.class, GroovyObject.class, (Object[])new Class[0]);
    private static final List<? extends PropertyAnnotationHandler> HANDLERS = Arrays.asList(new InputFilePropertyAnnotationHandler(), new InputDirectoryPropertyAnnotationHandler(), new InputFilesPropertyAnnotationHandler(), new OutputFilePropertyAnnotationHandler(), new OutputFilesPropertyAnnotationHandler(), new OutputDirectoryPropertyAnnotationHandler(), new OutputDirectoriesPropertyAnnotationHandler(), new InputPropertyAnnotationHandler(), new DestroysPropertyAnnotationHandler(), new NestedBeanPropertyAnnotationHandler(), new NoOpPropertyAnnotationHandler(Inject.class), new NoOpPropertyAnnotationHandler(Console.class), new NoOpPropertyAnnotationHandler(Internal.class), new NoOpPropertyAnnotationHandler(OptionValues.class));
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> annotationHandlers;
    private final Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides;
    private final Set<Class<? extends Annotation>> relevantAnnotationTypes;

    public DefaultTaskClassValidatorExtractor(PropertyAnnotationHandler ... customAnnotationHandlers) {
        this(Arrays.asList(customAnnotationHandlers));
    }

    public DefaultTaskClassValidatorExtractor(Iterable<? extends PropertyAnnotationHandler> customAnnotationHandlers) {
        ImmutableMap annotationsHandlers;
        Iterable allAnnotationHandlers = Iterables.concat(HANDLERS, customAnnotationHandlers);
        this.annotationHandlers = annotationsHandlers = Maps.uniqueIndex((Iterable)allAnnotationHandlers, (Function)new Function<PropertyAnnotationHandler, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(PropertyAnnotationHandler handler) {
                return handler.getAnnotationType();
            }
        });
        this.annotationOverrides = DefaultTaskClassValidatorExtractor.collectAnnotationOverrides(allAnnotationHandlers);
        this.relevantAnnotationTypes = DefaultTaskClassValidatorExtractor.collectRelevantAnnotationTypes(annotationsHandlers.keySet());
    }

    private static Multimap<Class<? extends Annotation>, Class<? extends Annotation>> collectAnnotationOverrides(Iterable<PropertyAnnotationHandler> allAnnotationHandlers) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PropertyAnnotationHandler handler : allAnnotationHandlers) {
            if (!(handler instanceof OverridingPropertyAnnotationHandler)) continue;
            builder.put(((OverridingPropertyAnnotationHandler)handler).getOverriddenAnnotationType(), handler.getAnnotationType());
        }
        return builder.build();
    }

    private static Set<Class<? extends Annotation>> collectRelevantAnnotationTypes(Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        return ImmutableSet.builder().addAll(propertyTypeAnnotations).add(Optional.class).add(SkipWhenEmpty.class).add(PathSensitive.class).build();
    }

    @Override
    public TaskClassValidator extractValidator(Class<? extends Task> type) {
        boolean cacheable = type.isAnnotationPresent(CacheableTask.class);
        ImmutableSortedSet.Builder annotatedPropertiesBuilder = ImmutableSortedSet.naturalOrder();
        ImmutableList.Builder validationMessages = ImmutableList.builder();
        ArrayDeque<TypeEntry> queue = new ArrayDeque<TypeEntry>();
        queue.add(new TypeEntry(null, type));
        while (!queue.isEmpty()) {
            TypeEntry entry = (TypeEntry)queue.remove();
            this.parseProperties(entry.parent, entry.type, (ImmutableSet.Builder<TaskPropertyInfo>)annotatedPropertiesBuilder, (ImmutableCollection.Builder<TaskClassValidationMessage>)validationMessages, cacheable, queue);
        }
        return new TaskClassValidator((Set<TaskPropertyInfo>)annotatedPropertiesBuilder.build(), (List<TaskClassValidationMessage>)validationMessages.build(), cacheable);
    }

    private <T> void parseProperties(final TaskPropertyInfo parent, Class<T> type, ImmutableSet.Builder<TaskPropertyInfo> annotatedProperties, final ImmutableCollection.Builder<TaskClassValidationMessage> validationMessages, final boolean cacheable, Queue<TypeEntry> queue) {
        final Set<Class<? extends Annotation>> propertyTypeAnnotations = this.annotationHandlers.keySet();
        final LinkedHashMap propertyContexts = Maps.newLinkedHashMap();
        Types.walkTypeHierarchy(type, IGNORED_SUPER_CLASSES, (Types.TypeVisitor)new Types.TypeVisitor<T>(){

            public void visitType(Class<? super T> type) {
                Map fields = DefaultTaskClassValidatorExtractor.getFields(type);
                List getters = DefaultTaskClassValidatorExtractor.getGetters(type);
                for (Getter getter : getters) {
                    Method method = getter.getMethod();
                    String fieldName = getter.getName();
                    Field field = (Field)fields.get(fieldName);
                    String propertyName = parent != null ? parent.getName() + '.' + fieldName : fieldName;
                    DefaultTaskPropertyActionContext propertyContext = (DefaultTaskPropertyActionContext)propertyContexts.get(propertyName);
                    if (propertyContext == null) {
                        propertyContext = new DefaultTaskPropertyActionContext(propertyTypeAnnotations, parent, propertyName, method, cacheable, (ImmutableCollection.Builder<TaskClassValidationMessage>)validationMessages);
                        propertyContexts.put(propertyName, propertyContext);
                    }
                    if (field != null) {
                        propertyContext.setInstanceVariableField(field);
                    }
                    Iterable declaredAnnotations = DefaultTaskClassValidatorExtractor.this.mergeDeclaredAnnotations(propertyContext, method, field);
                    Iterable overriddenAnnotations = DefaultTaskClassValidatorExtractor.this.filterOverridingAnnotations(declaredAnnotations, propertyTypeAnnotations);
                    DefaultTaskClassValidatorExtractor.this.recordAnnotations(propertyContext, overriddenAnnotations, propertyTypeAnnotations);
                }
            }
        });
        for (DefaultTaskPropertyActionContext propertyContext : propertyContexts.values()) {
            TaskPropertyInfo property = this.createProperty(propertyContext);
            if (property == null) continue;
            annotatedProperties.add((Object)property);
            Class<?> nestedType = propertyContext.getNestedType();
            if (nestedType == null) continue;
            queue.add(new TypeEntry(property, nestedType));
        }
    }

    private Iterable<Annotation> mergeDeclaredAnnotations(TaskPropertyActionContext propertyContext, Method method, Field field) {
        Collection<Annotation> methodAnnotations = this.collectRelevantAnnotations(method.getDeclaredAnnotations());
        if (field == null) {
            return methodAnnotations;
        }
        Collection<Annotation> fieldAnnotations = this.collectRelevantAnnotations(field.getDeclaredAnnotations());
        if (fieldAnnotations.isEmpty()) {
            return methodAnnotations;
        }
        if (methodAnnotations.isEmpty()) {
            return fieldAnnotations;
        }
        for (Annotation methodAnnotation : methodAnnotations) {
            Iterator<Annotation> iFieldAnnotation = fieldAnnotations.iterator();
            while (iFieldAnnotation.hasNext()) {
                Annotation fieldAnnotation = iFieldAnnotation.next();
                if (!methodAnnotation.annotationType().equals(fieldAnnotation.annotationType())) continue;
                propertyContext.validationMessage("has both a getter and field declared with annotation @" + methodAnnotation.annotationType().getSimpleName());
                iFieldAnnotation.remove();
            }
        }
        return Iterables.concat(methodAnnotations, fieldAnnotations);
    }

    private Collection<Annotation> collectRelevantAnnotations(Annotation[] annotations) {
        ArrayList relevantAnnotations = Lists.newArrayListWithCapacity((int)annotations.length);
        for (Annotation annotation : annotations) {
            if (!this.relevantAnnotationTypes.contains(annotation.annotationType())) continue;
            relevantAnnotations.add(annotation);
        }
        return relevantAnnotations;
    }

    private Iterable<Annotation> filterOverridingAnnotations(final Iterable<Annotation> declaredAnnotations, final Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        return Iterables.filter(declaredAnnotations, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                Class<? extends Annotation> annotationType = input.annotationType();
                if (!propertyTypeAnnotations.contains(annotationType)) {
                    return true;
                }
                for (Class overridingAnnotation : DefaultTaskClassValidatorExtractor.this.annotationOverrides.get(annotationType)) {
                    for (Annotation declaredAnnotation : declaredAnnotations) {
                        if (!declaredAnnotation.annotationType().equals(overridingAnnotation)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private void recordAnnotations(TaskPropertyActionContext propertyContext, Iterable<Annotation> annotations, Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        LinkedHashSet declaredPropertyTypes = Sets.newLinkedHashSet();
        for (Annotation annotation : annotations) {
            if (propertyTypeAnnotations.contains(annotation.annotationType())) {
                declaredPropertyTypes.add(annotation.annotationType());
            }
            propertyContext.addAnnotation(annotation);
        }
        if (declaredPropertyTypes.size() > 1) {
            propertyContext.validationMessage("has conflicting property types declared: " + Joiner.on((String)", ").join(Iterables.transform((Iterable)declaredPropertyTypes, (Function)new Function<Class<? extends Annotation>, String>(){

                public String apply(Class<? extends Annotation> annotationType) {
                    return "@" + annotationType.getSimpleName();
                }
            })));
        }
    }

    private TaskPropertyInfo createProperty(DefaultTaskPropertyActionContext propertyContext) {
        Class<? extends Annotation> propertyType = propertyContext.getPropertyType();
        if (propertyType != null) {
            if (propertyContext.isAnnotationPresent(Optional.class)) {
                propertyContext.setOptional(true);
            }
            PropertyAnnotationHandler handler = this.annotationHandlers.get(propertyType);
            handler.attachActions(propertyContext);
            return propertyContext.createProperty();
        }
        propertyContext.validationMessage("is not annotated with an input or output annotation");
        return null;
    }

    private static Map<String, Field> getFields(Class<?> type) {
        HashMap fields = Maps.newHashMap();
        for (Field field : type.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private static List<Getter> getGetters(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        ArrayList getters = Lists.newArrayListWithCapacity((int)methods.length);
        for (Method method : methods) {
            PropertyAccessorType accessorType = PropertyAccessorType.of((Method)method);
            if (accessorType == null || accessorType == PropertyAccessorType.SETTER || method.isBridge() || GroovyMethods.isObjectMethod((Method)method)) continue;
            getters.add(new Getter(method, accessorType.propertyNameFor(method)));
        }
        Collections.sort(getters);
        return getters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTaskPropertyActionContext
    implements TaskPropertyActionContext {
        private final Set<Class<? extends Annotation>> propertyTypeAnnotations;
        private final TaskPropertyInfo parent;
        private final String name;
        private final Method method;
        private final List<Annotation> annotations = Lists.newArrayList();
        private final boolean cacheable;
        private final ImmutableCollection.Builder<TaskClassValidationMessage> validationMessages;
        private Field instanceVariableField;
        private ValidationAction validationAction;
        private UpdateAction configureAction;
        private boolean optional;
        private Class<?> nestedType;
        private Class<? extends Annotation> propertyType;

        public DefaultTaskPropertyActionContext(Set<Class<? extends Annotation>> propertyTypeAnnotations, TaskPropertyInfo parent, String name, Method method, boolean cacheable, ImmutableCollection.Builder<TaskClassValidationMessage> validationMessages) {
            this.propertyTypeAnnotations = propertyTypeAnnotations;
            this.parent = parent;
            this.name = name;
            this.method = method;
            this.cacheable = cacheable;
            this.validationMessages = validationMessages;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public Class<?> getValueType() {
            return this.instanceVariableField != null ? this.instanceVariableField.getType() : this.method.getReturnType();
        }

        @Override
        public void addAnnotation(Annotation annotation) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (this.propertyType == null && this.isPropertyTypeAnnotation(annotationType)) {
                this.propertyType = annotationType;
            }
            if (!this.isAnnotationPresent(annotation.annotationType())) {
                this.annotations.add(annotation);
            }
        }

        private boolean isPropertyTypeAnnotation(Class<? extends Annotation> annotationType) {
            return this.propertyTypeAnnotations.contains(annotationType);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotationType.equals(annotation.annotationType())) continue;
                return (A)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        public void setInstanceVariableField(Field instanceVariableField) {
            if (this.instanceVariableField == null && instanceVariableField != null) {
                this.instanceVariableField = instanceVariableField;
            }
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public boolean isCacheable() {
            return this.cacheable;
        }

        @Override
        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        @Override
        public void setValidationAction(ValidationAction action) {
            this.validationAction = action;
        }

        @Override
        public void setConfigureAction(UpdateAction action) {
            this.configureAction = action;
        }

        public Class<?> getNestedType() {
            return this.nestedType;
        }

        @Override
        public void setNestedType(Class<?> nestedType) {
            this.nestedType = nestedType;
        }

        public TaskPropertyInfo createProperty() {
            if (this.configureAction == null && this.validationAction == null) {
                return null;
            }
            return new TaskPropertyInfo(this.parent, this.name, this.propertyType, this.method, this.validationAction, this.configureAction, this.optional);
        }

        @Override
        public void validationMessage(String message) {
            this.validationMessages.add((Object)TaskClassValidationMessage.property(this.name, message));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Getter
    implements Comparable<Getter> {
        private final Method method;
        private final String name;

        public Getter(Method method, String name) {
            this.method = method;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public int compareTo(Getter o) {
            return this.method.getName().compareTo(o.method.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeEntry {
        private final TaskPropertyInfo parent;
        private final Class<?> type;

        public TypeEntry(TaskPropertyInfo parent, Class<?> type) {
            this.parent = parent;
            this.type = type;
        }
    }
}

