/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.internal.nativeintegration.filesystem.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesSnapshotter {
    public TaskExecutionHistory.OverlappingOutputs detectOverlappingOutputs(String propertyName, FileCollectionSnapshot previousExecution, FileCollectionSnapshot beforeExecution) {
        Map<String, NormalizedFileSnapshot> previousSnapshots = previousExecution.getSnapshots();
        Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
        for (Map.Entry<String, NormalizedFileSnapshot> beforeSnapshot : beforeSnapshots.entrySet()) {
            String path = beforeSnapshot.getKey();
            NormalizedFileSnapshot fileSnapshot = beforeSnapshot.getValue();
            NormalizedFileSnapshot previousSnapshot = previousSnapshots.get(path);
            if (fileSnapshot.getSnapshot().getType() != FileType.RegularFile || !this.createdSincePreviousExecution(previousSnapshot) && !this.changedSincePreviousExecution(fileSnapshot, previousSnapshot)) continue;
            return new TaskExecutionHistory.OverlappingOutputs(propertyName, fileSnapshot.getNormalizedPath());
        }
        return null;
    }

    private boolean changedSincePreviousExecution(NormalizedFileSnapshot fileSnapshot, NormalizedFileSnapshot previousSnapshot) {
        return !previousSnapshot.getSnapshot().isContentUpToDate(fileSnapshot.getSnapshot());
    }

    private boolean createdSincePreviousExecution(NormalizedFileSnapshot previousSnapshot) {
        return previousSnapshot == null;
    }

    public FileCollectionSnapshot createOutputSnapshot(FileCollectionSnapshot afterPreviousExecution, FileCollectionSnapshot beforeExecution, FileCollectionSnapshot afterExecution) {
        FileCollectionSnapshot filesSnapshot;
        Map<String, NormalizedFileSnapshot> afterSnapshots = afterExecution.getSnapshots();
        if (!beforeExecution.getSnapshots().isEmpty() && !afterSnapshots.isEmpty()) {
            Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
            HashMap<String, NormalizedFileSnapshot> afterPreviousSnapshots = afterPreviousExecution != null ? afterPreviousExecution.getSnapshots() : new HashMap<String, NormalizedFileSnapshot>();
            int newEntryCount = 0;
            ImmutableMap.Builder outputEntries = ImmutableMap.builder();
            for (Map.Entry<String, NormalizedFileSnapshot> entry : afterSnapshots.entrySet()) {
                NormalizedFileSnapshot fileSnapshot;
                String path = entry.getKey();
                if (!OutputFilesSnapshotter.isOutputEntry(path, fileSnapshot = entry.getValue(), beforeSnapshots, afterPreviousSnapshots)) continue;
                outputEntries.put((Object)entry.getKey(), (Object)fileSnapshot);
                ++newEntryCount;
            }
            filesSnapshot = newEntryCount == afterSnapshots.size() ? afterExecution : new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)outputEntries.build(), TaskFilePropertyCompareStrategy.OUTPUT, true);
        } else {
            filesSnapshot = afterExecution;
        }
        return filesSnapshot;
    }

    private static boolean isOutputEntry(String path, NormalizedFileSnapshot fileSnapshot, Map<String, NormalizedFileSnapshot> beforeSnapshots, Map<String, NormalizedFileSnapshot> afterPreviousSnapshots) {
        NormalizedFileSnapshot beforeSnapshot = beforeSnapshots.get(path);
        if (beforeSnapshot == null) {
            return true;
        }
        if (!fileSnapshot.getSnapshot().isContentAndMetadataUpToDate(beforeSnapshot.getSnapshot())) {
            return true;
        }
        return afterPreviousSnapshots.containsKey(path);
    }
}

