/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveBuildCacheKeyExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveBuildCacheKeyExecuter.class);
    private final TaskOutputCachingListener listener;
    private final TaskExecuter delegate;

    public ResolveBuildCacheKeyExecuter(TaskOutputCachingListener listener, TaskExecuter delegate) {
        this.listener = listener;
        this.delegate = delegate;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskArtifactState taskState = context.getTaskArtifactState();
        TaskOutputCachingBuildCacheKey cacheKey = taskState.calculateCacheKey();
        context.setBuildCacheKey(cacheKey);
        if (task.getOutputs().getHasOutput()) {
            this.listener.cacheKeyEvaluated(task, cacheKey);
            if (cacheKey.isValid()) {
                LOGGER.info("Cache key for {} is {}", (Object)task, (Object)cacheKey.getHashCode());
            }
        }
        this.delegate.execute(task, state, context);
    }
}

