/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Nullable;
import org.gradle.api.internal.changedetection.state.DirectoryTreeDetails;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;

public class DefaultFileSystemMirror
extends BuildAdapter
implements FileSystemMirror,
TaskOutputsGenerationListener {
    private final Map<String, FileDetails> files = new ConcurrentHashMap<String, FileDetails>();
    private final Map<String, DirectoryTreeDetails> trees = new ConcurrentHashMap<String, DirectoryTreeDetails>();

    @Nullable
    public FileDetails getFile(String path) {
        return this.files.get(path);
    }

    public void putFile(FileDetails file) {
        this.files.put(file.getPath(), file);
    }

    @Nullable
    public DirectoryTreeDetails getDirectoryTree(String path) {
        return this.trees.get(path);
    }

    public void putDirectory(DirectoryTreeDetails directory) {
        this.trees.put(directory.path, directory);
    }

    public void beforeTaskOutputsGenerated() {
        this.throwAwayAllCachedState();
    }

    public void buildFinished(BuildResult result) {
        this.throwAwayAllCachedState();
    }

    private void throwAwayAllCachedState() {
        this.files.clear();
        this.trees.clear();
    }
}

