/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.caching.BuildCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortCircuitingErrorHandlerBuildCacheDecorator
implements BuildCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortCircuitingErrorHandlerBuildCacheDecorator.class);
    private final BuildCache delegate;
    private final int maxErrorCount;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final AtomicInteger remainingErrorCount;

    public ShortCircuitingErrorHandlerBuildCacheDecorator(int maxErrorCount, BuildCache delegate) {
        this.delegate = delegate;
        this.maxErrorCount = maxErrorCount;
        this.remainingErrorCount = new AtomicInteger(maxErrorCount);
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        if (this.enabled.get()) {
            try {
                return this.delegate.load(key, reader);
            }
            catch (BuildCacheException e) {
                this.recordFailure();
                throw e;
            }
        }
        return false;
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) throws BuildCacheException {
        if (this.enabled.get()) {
            try {
                this.delegate.store(key, writer);
            }
            catch (BuildCacheException e) {
                this.recordFailure();
                throw e;
            }
        }
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public void close() throws IOException {
        if (!this.enabled.get()) {
            LOGGER.warn("{} was disabled during the build after encountering {} errors.", (Object)this.getDescription(), (Object)this.maxErrorCount);
        }
        this.delegate.close();
    }

    private void recordFailure() {
        if (this.remainingErrorCount.decrementAndGet() <= 0 && this.enabled.compareAndSet(true, false)) {
            LOGGER.warn("{} is now disabled because {} errors were encountered", (Object)this.getDescription(), (Object)this.maxErrorCount);
        }
    }
}

