/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.HashCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.AbstractFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.CompileClasspathSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.JvmClassHasher;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.internal.FileUtils;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompileClasspathSnapshotter
extends AbstractFileCollectionSnapshotter
implements CompileClasspathSnapshotter {
    private static final Comparator<FileDetails> FILE_DETAILS_COMPARATOR = new Comparator<FileDetails>(){

        @Override
        public int compare(FileDetails o1, FileDetails o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private static final HashCode IGNORED = HashCode.fromInt((int)(DefaultCompileClasspathSnapshotter.class.getName() + " : ignored").hashCode());
    private final JvmClassHasher jvmClassHasher;

    public DefaultCompileClasspathSnapshotter(FileHasher hasher, StringInterner stringInterner, FileSystem fileSystem, DirectoryFileTreeFactory directoryFileTreeFactory, FileSystemMirror fileSystemMirror, JvmClassHasher jvmClassHasher) {
        super(hasher, stringInterner, fileSystem, directoryFileTreeFactory, fileSystemMirror);
        this.jvmClassHasher = jvmClassHasher;
    }

    @Override
    public Class<? extends FileCollectionSnapshotter> getRegisteredType() {
        return CompileClasspathSnapshotter.class;
    }

    @Override
    protected List<FileDetails> normaliseTreeElements(List<FileDetails> nonRootElements) {
        ArrayList<FileDetails> sorted = new ArrayList<FileDetails>(nonRootElements.size());
        for (FileDetails details : nonRootElements) {
            HashCode signatureForClass;
            if (details.getType() != FileType.RegularFile || !details.getName().endsWith(".class") || (signatureForClass = this.jvmClassHasher.hashClassFile(details)) == null) continue;
            sorted.add(details.withContent(signatureForClass));
        }
        Collections.sort(sorted, FILE_DETAILS_COMPARATOR);
        return sorted;
    }

    @Override
    protected FileDetails normaliseFileElement(FileDetails details) {
        if (FileUtils.isJar((String)details.getName())) {
            return details.withContent(this.jvmClassHasher.hashJarFile(details));
        }
        return details.withContent(IGNORED);
    }
}

