/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.CompositeTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.DefaultCacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.NonCacheableTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputPropertySpecAndBuilder;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.OrSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private final FileCollection allOutputFiles;
    private AndSpec<TaskInternal> upToDateSpec = AndSpec.empty();
    private AndSpec<TaskInternal> cacheIfSpec = AndSpec.empty();
    private OrSpec<TaskInternal> doNotCacheIfSpec = OrSpec.empty();
    private TaskExecutionHistory history;
    private final List<TaskOutputPropertySpecAndBuilder> filePropertiesInternal = Lists.newArrayList();
    private SortedSet<TaskOutputFilePropertySpec> fileProperties;
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;

    public DefaultTaskOutputs(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
        DefaultTaskDependency buildDependencies = new DefaultTaskDependency();
        buildDependencies.add(task);
        this.allOutputFiles = new TaskOutputUnionFileCollection("task '" + task.getName() + "' output files", buildDependencies);
    }

    @Override
    public Spec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    @Override
    public void upToDateWhen(final Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(upToDateClosure);
            }
        });
    }

    @Override
    public void upToDateWhen(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(new Spec[]{spec});
            }
        });
    }

    @Override
    public boolean isCacheEnabled() {
        return !this.cacheIfSpec.getSpecs().isEmpty() && this.cacheIfSpec.isSatisfiedBy((Object)this.task) && (this.doNotCacheIfSpec.isEmpty() || !this.doNotCacheIfSpec.isSatisfiedBy((Object)this.task));
    }

    @Override
    public boolean isCacheAllowed() {
        for (TaskPropertySpec taskPropertySpec : this.getFileProperties()) {
            if (!(taskPropertySpec instanceof NonCacheableTaskOutputPropertySpec)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cacheIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.cacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.cacheIfSpec = DefaultTaskOutputs.this.cacheIfSpec.and(new Spec[]{spec});
            }
        });
    }

    @Override
    public void doNotCacheIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.doNotCacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.doNotCacheIfSpec = DefaultTaskOutputs.this.doNotCacheIfSpec.or(new Spec[]{spec});
            }
        });
    }

    @Override
    public boolean getHasOutput() {
        return this.hasDeclaredOutputs() || !this.upToDateSpec.isEmpty();
    }

    @Override
    public boolean hasDeclaredOutputs() {
        return !this.filePropertiesInternal.isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.allOutputFiles;
    }

    @Override
    public SortedSet<TaskOutputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            TaskPropertyUtils.ensurePropertiesHaveNames(this.filePropertiesInternal);
            Iterator flattenedProperties = Iterators.concat(Iterables.transform(this.filePropertiesInternal, (Function)new Function<TaskPropertySpec, Iterator<? extends TaskOutputFilePropertySpec>>(){

                public Iterator<? extends TaskOutputFilePropertySpec> apply(TaskPropertySpec propertySpec) {
                    if (propertySpec instanceof CompositeTaskOutputPropertySpec) {
                        return ((CompositeTaskOutputPropertySpec)propertySpec).resolveToOutputProperties();
                    }
                    return Iterators.singletonIterator((Object)((TaskOutputFilePropertySpec)propertySpec));
                }
            }).iterator());
            this.fileProperties = TaskPropertyUtils.collectFileProperties("output", flattenedProperties);
        }
        return this.fileProperties;
    }

    @Override
    public TaskOutputFilePropertyBuilder file(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.file(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new DefaultCacheableTaskOutputFilePropertySpec(DefaultTaskOutputs.this, DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.FILE, path));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder dir(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.dir(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new DefaultCacheableTaskOutputFilePropertySpec(DefaultTaskOutputs.this, DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY, path));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder files(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.files(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new CompositeTaskOutputPropertySpec(DefaultTaskOutputs.this, DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.FILE, paths));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder dirs(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.dirs(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new CompositeTaskOutputPropertySpec(DefaultTaskOutputs.this, DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY, paths));
            }
        });
    }

    private TaskOutputFilePropertyBuilder addSpec(TaskOutputPropertySpecAndBuilder spec) {
        this.filePropertiesInternal.add(spec);
        return spec;
    }

    @Override
    public FileCollection getPreviousOutputFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(TaskExecutionHistory history) {
        this.history = history;
    }

    private class TaskOutputUnionFileCollection
    extends CompositeFileCollection {
        private final String displayName;
        private final DefaultTaskDependency buildDependencies;

        public TaskOutputUnionFileCollection(String displayName, DefaultTaskDependency buildDependencies) {
            this.displayName = displayName;
            this.buildDependencies = buildDependencies;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void visitContents(FileCollectionResolveContext context) {
            for (TaskFilePropertySpec taskFilePropertySpec : DefaultTaskOutputs.this.getFileProperties()) {
                context.add(taskFilePropertySpec.getPropertyFiles());
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.buildDependencies);
            super.visitDependencies(context);
        }
    }
}

