/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.Map;
import org.gradle.api.internal.project.taskfactory.ClasspathPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.DefaultTaskClassInfoStore;
import org.gradle.api.internal.project.taskfactory.DefaultTaskClassValidatorExtractor;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPropertyValidationAccess {
    public static void collectTaskValidationProblems(Class<?> task, Map<String, Boolean> problems) {
        DefaultTaskClassInfoStore infoStore = new DefaultTaskClassInfoStore(new DefaultTaskClassValidatorExtractor(new ClasspathPropertyAnnotationHandler()));
        TaskClassInfo info = infoStore.getTaskClassInfo((Class)Cast.uncheckedCast(task));
        for (String nonAnnotatedPropertyName : info.getNonAnnotatedPropertyNames()) {
            problems.put(String.format("Task type '%s' declares property that is not annotated: '%s'.", task.getName(), nonAnnotatedPropertyName), Boolean.FALSE);
        }
    }
}

