/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStore;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBackedInMemoryStore
implements PersistentStore,
CacheAccess {
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
        return new CacheImpl(this.lock);
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> action) {
        this.lock.lock();
        try {
            Object object = action.create();
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.lock.lock();
        try {
            action.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        return (T)action.create();
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        action.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheImpl<K, V>
    implements PersistentIndexedCache<K, V> {
        private final ReentrantLock lock;
        Map<K, V> entries = Maps.newHashMap();

        CacheImpl(ReentrantLock lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(K key) {
            this.lock.lock();
            try {
                V v = this.entries.get(key);
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(K key, V value) {
            this.lock.lock();
            try {
                this.entries.put(key, value);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(K key) {
            this.lock.lock();
            try {
                this.entries.remove(key);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

