/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveTaskArtifactStateTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveTaskArtifactStateTaskExecuter.class);
    private final TaskExecuter executer;
    private final TaskArtifactStateRepository repository;

    public ResolveTaskArtifactStateTaskExecuter(TaskArtifactStateRepository repository, TaskExecuter executer) {
        this.executer = executer;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        Clock clock = new Clock();
        context.setTaskArtifactState(this.repository.getStateFor(task));
        LOGGER.info("Putting task artifact state for {} into context took {}.", (Object)task, (Object)clock.getTime());
        try {
            this.executer.execute(task, state, context);
        }
        finally {
            context.setTaskArtifactState(null);
            LOGGER.debug("Removed task artifact state for {} from context.");
        }
    }
}

