/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.tasks.TaskPropertyBuilder;

abstract class AbstractTaskPropertyBuilder
implements TaskPropertyBuilder {
    private String propertyName;

    AbstractTaskPropertyBuilder() {
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected void setPropertyName(String propertyName) {
        if (propertyName != null) {
            if (propertyName.length() == 0) {
                throw new IllegalArgumentException("Property name must not be empty string");
            }
            if (!Character.isJavaIdentifierStart(propertyName.codePointAt(0))) {
                throw new IllegalArgumentException(String.format("Property name '%s' must be a valid Java identifier", propertyName));
            }
            boolean previousCharWasADot = false;
            for (int idx = 1; idx < propertyName.length(); ++idx) {
                int chr = propertyName.codePointAt(idx);
                if (chr == 46 && !previousCharWasADot && idx < propertyName.length() - 1) {
                    previousCharWasADot = true;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(chr)) {
                    throw new IllegalArgumentException(String.format("Property name '%s' must be a valid Java identifier", propertyName));
                }
                previousCharWasADot = false;
            }
        }
        this.propertyName = propertyName;
    }

    public String toString() {
        return this.propertyName == null ? "<unnamed>" : this.propertyName;
    }
}

