/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.gradle.api.JavaVersion;
import org.gradle.api.Nullable;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.worker.JavaExecutableVersionProber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaExecutableVersionProber
implements JavaExecutableVersionProber {
    static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("^java version \"(.*?)\"$");

    @Override
    @Nullable
    public JavaVersion probeVersion(JavaExecSpec execSpec) {
        return this.findJavaVersion(this.execJavaVersion(execSpec));
    }

    private List<String> execJavaVersion(JavaExecSpec execSpec) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.redirectErrorStream(true);
        processBuilder.command(execSpec.getExecutable(), "-version");
        try {
            Process process = processBuilder.start();
            return IOUtils.readLines((InputStream)process.getInputStream());
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    @Nullable
    JavaVersion findJavaVersion(List<String> lines) {
        for (String line : lines) {
            Matcher matcher = JAVA_VERSION_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            return JavaVersion.toVersion((Object)matcher.group(1));
        }
        return null;
    }
}

