/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.JavaVersion;
import org.gradle.api.Nullable;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.worker.JavaExecutableVersionProber;

public class CachedJavaExecutableVersionProber
implements JavaExecutableVersionProber {
    private final JavaExecutableVersionProber delegate;
    private final ConcurrentMap<String, OptionalValue> cache = new ConcurrentHashMap<String, OptionalValue>();

    public CachedJavaExecutableVersionProber(JavaExecutableVersionProber delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public JavaVersion probeVersion(JavaExecSpec execSpec) {
        String key = execSpec.getExecutable();
        OptionalValue optionalValue = (OptionalValue)this.cache.get(key);
        if (optionalValue == null) {
            optionalValue = new OptionalValue(this.delegate.probeVersion(execSpec));
            this.cache.put(key, optionalValue);
        }
        return optionalValue.value;
    }

    private static class OptionalValue {
        final JavaVersion value;

        private OptionalValue(JavaVersion value) {
            this.value = value;
        }
    }
}

