/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.IOException;
import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputPacker;
import org.gradle.api.internal.tasks.cache.TaskOutputReader;
import org.gradle.api.internal.tasks.cache.TaskOutputWriter;
import org.gradle.util.Clock;
import org.gradle.util.SingleMessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipCachedTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipCachedTaskExecuter.class);
    private final TaskArtifactStateRepository repository;
    private final TaskOutputCache cache;
    private final TaskOutputPacker packer;
    private final TaskExecuter delegate;

    public SkipCachedTaskExecuter(TaskArtifactStateRepository repository, TaskOutputCache cache, TaskOutputPacker packer, TaskExecuter delegate) {
        this.repository = repository;
        this.cache = cache;
        this.packer = packer;
        this.delegate = delegate;
        SingleMessageLogger.incubatingFeatureUsed((String)"Task output caching");
        LOGGER.info("Using {}", (Object)cache.getDescription());
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        Object cachedOutput;
        boolean shouldCache;
        Clock clock = new Clock();
        TaskOutputsInternal taskOutputs = task.getOutputs();
        boolean cacheAllowed = taskOutputs.isCacheAllowed();
        try {
            shouldCache = cacheAllowed && taskOutputs.isCacheEnabled();
        }
        catch (Exception t) {
            state.executed(new GradleException(String.format("Could not evaluate TaskOutputs.isCacheEnabled() for %s.", task), (Throwable)t));
            return;
        }
        LOGGER.debug("Determining if {} is cached already", (Object)task);
        TaskCacheKey cacheKey = null;
        if (shouldCache) {
            TaskArtifactState taskState = this.repository.getStateFor(task);
            try {
                cacheKey = taskState.calculateCacheKey();
                LOGGER.debug("Cache key for {} is {}", (Object)task, (Object)cacheKey);
            }
            catch (Exception e) {
                LOGGER.info(String.format("Could not build cache key for task %s", task), (Throwable)e);
            }
        } else if (!cacheAllowed) {
            LOGGER.debug("Not caching {} as it is not allowed", (Object)task);
        } else {
            LOGGER.debug("Not caching {} as task output is not cacheable.", (Object)task);
        }
        if (cacheKey != null) {
            try {
                cachedOutput = this.cache.get(cacheKey);
                if (cachedOutput != null) {
                    this.packer.unpack(taskOutputs, (TaskOutputReader)cachedOutput);
                    LOGGER.info("Unpacked output for {} from cache (took {}).", (Object)task, (Object)clock.getTime());
                    state.upToDate("CACHED");
                    return;
                }
            }
            catch (IOException e) {
                LOGGER.info(String.format("Could not load cached output for %s with cache key %s", task, cacheKey), (Throwable)e);
            }
        }
        this.delegate.execute(task, state, context);
        if (cacheKey != null && state.getFailure() == null) {
            try {
                cachedOutput = this.packer.createWriter(taskOutputs);
                this.cache.put(cacheKey, (TaskOutputWriter)cachedOutput);
            }
            catch (IOException e) {
                LOGGER.info(String.format("Could not cache results for %s for cache key %s", task, cacheKey), (Throwable)e);
            }
        }
    }
}

