/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache;

import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputReader;
import org.gradle.api.internal.tasks.cache.TaskOutputWriter;

public class LocalDirectoryTaskOutputCache
implements TaskOutputCache {
    private final File directory;

    public LocalDirectoryTaskOutputCache(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
        this.directory = directory;
    }

    public TaskOutputReader get(TaskCacheKey key) throws IOException {
        final File file = this.getFile(key.getHashCode());
        if (file.isFile()) {
            return new TaskOutputReader(){

                public ByteSource read() throws IOException {
                    return Files.asByteSource((File)file);
                }
            };
        }
        return null;
    }

    public void put(TaskCacheKey key, TaskOutputWriter result) throws IOException {
        result.writeTo(Files.asByteSink((File)this.getFile(key.getHashCode()), (FileWriteMode[])new FileWriteMode[0]));
    }

    private File getFile(HashCode key) {
        return new File(this.directory, key.toString());
    }

    public String getDescription() {
        return "local directory cache in " + this.directory;
    }
}

