/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Callables;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.AbstractTaskPropertyBuilder;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private static final AndSpec<TaskInternal> EMPTY_AND_SPEC = new AndSpec();
    private final FileCollection allOutputFiles;
    private AndSpec<TaskInternal> upToDateSpec = EMPTY_AND_SPEC;
    private AndSpec<TaskInternal> cacheIfSpec = EMPTY_AND_SPEC;
    private TaskExecutionHistory history;
    private final List<BasePropertySpec> filePropertiesInternal = Lists.newArrayList();
    private SortedSet<TaskOutputFilePropertySpec> fileProperties;
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;

    public DefaultTaskOutputs(FileResolver resolver, final TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
        final DefaultTaskDependency buildDependencies = new DefaultTaskDependency();
        buildDependencies.add(task);
        this.allOutputFiles = new CompositeFileCollection(){

            public String getDisplayName() {
                return task + " output files";
            }

            public void visitContents(FileCollectionResolveContext context) {
                for (TaskFilePropertySpec taskFilePropertySpec : DefaultTaskOutputs.this.getFileProperties()) {
                    context.add(taskFilePropertySpec.getPropertyFiles());
                }
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(buildDependencies);
                super.visitDependencies(context);
            }
        };
    }

    @Override
    public Spec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    @Override
    public void upToDateWhen(final Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(upToDateClosure);
            }
        });
    }

    @Override
    public void upToDateWhen(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(new Spec[]{spec});
            }
        });
    }

    @Override
    public boolean isCacheEnabled() {
        return !this.cacheIfSpec.getSpecs().isEmpty() && this.cacheIfSpec.isSatisfiedBy((Object)this.task);
    }

    @Override
    public boolean isCacheAllowed() {
        return !this.filePropertiesInternal.isEmpty();
    }

    @Override
    public void cacheIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.cacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.cacheIfSpec = DefaultTaskOutputs.this.cacheIfSpec.and(new Spec[]{spec});
            }
        });
    }

    @Override
    public boolean getHasOutput() {
        return !this.filePropertiesInternal.isEmpty() || !this.upToDateSpec.isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.allOutputFiles;
    }

    @Override
    public SortedSet<TaskOutputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            TaskPropertyUtils.ensurePropertiesHaveNames(this.filePropertiesInternal);
            Iterable flattenedProperties = Iterables.concat((Iterable)Iterables.transform(this.filePropertiesInternal, (Function)new Function<BasePropertySpec, Iterable<TaskOutputFilePropertySpec>>(){

                public Iterable<TaskOutputFilePropertySpec> apply(BasePropertySpec propertySpec) {
                    if (propertySpec instanceof CompositePropertySpec) {
                        return (CompositePropertySpec)((Object)propertySpec);
                    }
                    return Collections.singleton((TaskOutputFilePropertySpec)((Object)propertySpec));
                }
            }));
            this.fileProperties = TaskPropertyUtils.collectFileProperties("output", flattenedProperties);
        }
        return this.fileProperties;
    }

    @Override
    public TaskOutputFilePropertyBuilder file(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.file(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new DefaultPropertySpec(DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, TaskOutputFilePropertySpec.OutputType.FILE, path));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder dir(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.dir(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new DefaultPropertySpec(DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, TaskOutputFilePropertySpec.OutputType.DIRECTORY, path));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder namedFiles(final Callable<Map<?, ?>> paths) {
        return this.taskMutator.mutate("TaskOutputs.namedFiles(Callable)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new NamedCompositePropertySpec(DefaultTaskOutputs.this.resolver, TaskOutputFilePropertySpec.OutputType.FILE, paths));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder namedFiles(final Map<?, ?> paths) {
        return this.taskMutator.mutate("TaskOutputs.namedFiles(Map)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                Callable callable = Callables.returning((Object)ImmutableMap.copyOf((Map)paths));
                return DefaultTaskOutputs.this.addSpec(new NamedCompositePropertySpec(DefaultTaskOutputs.this.resolver, TaskOutputFilePropertySpec.OutputType.FILE, callable));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder files(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.files(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.addSpec(new UnnamedCompositePropertySpec(DefaultTaskOutputs.this.task.getName(), DefaultTaskOutputs.this.resolver, TaskOutputFilePropertySpec.OutputType.FILE, paths));
            }
        });
    }

    private TaskOutputFilePropertyBuilder addSpec(BasePropertySpec spec) {
        this.filePropertiesInternal.add(spec);
        return spec;
    }

    @Override
    public FileCollection getPreviousFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(TaskExecutionHistory history) {
        this.history = history;
    }

    private class ElementPropertySpec
    implements TaskOutputFilePropertySpec {
        private final CompositePropertySpec parentProperty;
        private final String propertySuffix;
        private final FileCollection files;
        private final File file;

        public ElementPropertySpec(CompositePropertySpec parentProperty, String propertySuffix, File file) {
            this.parentProperty = parentProperty;
            this.propertySuffix = propertySuffix;
            this.files = new SimpleFileCollection(Collections.singleton(file));
            this.file = file;
        }

        public String getPropertyName() {
            return this.parentProperty.getPropertyName() + this.propertySuffix;
        }

        public FileCollection getPropertyFiles() {
            return this.files;
        }

        public File getOutputFile() {
            return this.file;
        }

        public TaskOutputFilePropertySpec.OutputType getOutputType() {
            return this.parentProperty.getOutputType();
        }

        public int compareTo(TaskPropertySpec o) {
            return this.getPropertyName().compareTo(o.getPropertyName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamedCompositePropertySpec
    extends BasePropertySpec
    implements CompositePropertySpec {
        private final TaskOutputFilePropertySpec.OutputType outputType;
        private final Callable<Map<?, ?>> paths;
        private final FileResolver resolver;

        public NamedCompositePropertySpec(FileResolver resolver, TaskOutputFilePropertySpec.OutputType outputType, Callable<Map<?, ?>> paths) {
            this.resolver = resolver;
            this.outputType = outputType;
            this.paths = paths;
        }

        @Override
        public TaskOutputFilePropertySpec.OutputType getOutputType() {
            return this.outputType;
        }

        @Override
        public Iterator<TaskOutputFilePropertySpec> iterator() {
            final Iterator iterator = ((Map)GUtil.uncheckedCall(this.paths)).entrySet().iterator();
            return new AbstractIterator<TaskOutputFilePropertySpec>(){

                protected TaskOutputFilePropertySpec computeNext() {
                    if (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        String id = entry.getKey().toString();
                        File file = NamedCompositePropertySpec.this.resolver.resolve(entry.getValue());
                        return new ElementPropertySpec(NamedCompositePropertySpec.this, "." + id, file);
                    }
                    return (TaskOutputFilePropertySpec)this.endOfData();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnnamedCompositePropertySpec
    extends DefaultPropertySpec
    implements CompositePropertySpec {
        public UnnamedCompositePropertySpec(String taskName, FileResolver resolver, TaskOutputFilePropertySpec.OutputType outputType, Object paths) {
            super(taskName, resolver, outputType, paths);
        }

        @Override
        public Iterator<TaskOutputFilePropertySpec> iterator() {
            final Iterator fileIterator = this.getPropertyFiles().iterator();
            return new AbstractIterator<TaskOutputFilePropertySpec>(){
                int counter;

                protected TaskOutputFilePropertySpec computeNext() {
                    if (fileIterator.hasNext()) {
                        return new ElementPropertySpec(UnnamedCompositePropertySpec.this, "$" + ++this.counter, (File)fileIterator.next());
                    }
                    return (TaskOutputFilePropertySpec)this.endOfData();
                }
            };
        }
    }

    private class DefaultPropertySpec
    extends BasePropertySpec
    implements TaskOutputFilePropertySpec {
        private final TaskPropertyFileCollection files;
        private final TaskOutputFilePropertySpec.OutputType outputType;
        private final FileResolver resolver;
        private final Object path;

        public DefaultPropertySpec(String taskName, FileResolver resolver, TaskOutputFilePropertySpec.OutputType outputType, Object path) {
            this.resolver = resolver;
            this.outputType = outputType;
            this.path = path;
            this.files = new TaskPropertyFileCollection(taskName, "output", this, resolver, path);
        }

        public FileCollection getPropertyFiles() {
            return this.files;
        }

        public File getOutputFile() {
            return this.resolver.resolve(this.path);
        }

        public TaskOutputFilePropertySpec.OutputType getOutputType() {
            return this.outputType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BasePropertySpec
    extends AbstractTaskPropertyBuilder
    implements TaskPropertySpec,
    TaskOutputFilePropertyBuilder {
        private boolean optional;

        private BasePropertySpec() {
        }

        @Override
        public TaskOutputFilePropertyBuilder withPropertyName(String propertyName) {
            this.setPropertyName(propertyName);
            return this;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public TaskOutputFilePropertyBuilder optional() {
            return this.optional(true);
        }

        @Override
        public TaskOutputFilePropertyBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        private TaskOutputs getTaskOutputs(String method) {
            DeprecationLogger.nagUserOfDiscontinuedMethod((String)("chaining of the " + method), (String)String.format("Use '%s' on TaskOutputs directly instead.", method));
            return DefaultTaskOutputs.this;
        }

        @Override
        public void upToDateWhen(Closure upToDateClosure) {
            this.getTaskOutputs("upToDateWhen(Closure)").upToDateWhen(upToDateClosure);
        }

        @Override
        public void upToDateWhen(Spec<? super Task> upToDateSpec) {
            this.getTaskOutputs("upToDateWhen(Spec)").upToDateWhen(upToDateSpec);
        }

        @Override
        public void cacheIf(Spec<? super Task> spec) {
            this.getTaskOutputs("cacheIf(Spec)").cacheIf(spec);
        }

        @Override
        public boolean getHasOutput() {
            return this.getTaskOutputs("getHasOutput()").getHasOutput();
        }

        @Override
        public FileCollection getFiles() {
            return this.getTaskOutputs("getFiles()").getFiles();
        }

        @Override
        @Deprecated
        public TaskOutputFilePropertyBuilder files(Object ... paths) {
            return this.getTaskOutputs("files(Object...)").files(paths);
        }

        @Override
        public TaskOutputFilePropertyBuilder file(Object path) {
            return this.getTaskOutputs("file(Object)").file(path);
        }

        @Override
        public TaskOutputFilePropertyBuilder dir(Object path) {
            return this.getTaskOutputs("dir(Object)").dir(path);
        }

        @Override
        public int compareTo(TaskPropertySpec o) {
            return this.getPropertyName().compareTo(o.getPropertyName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CompositePropertySpec
    extends TaskPropertySpec,
    Iterable<TaskOutputFilePropertySpec> {
        public TaskOutputFilePropertySpec.OutputType getOutputType();
    }
}

