/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.Lists;
import groovy.lang.GString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.AbstractTaskPropertyBuilder;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputs
implements TaskInputsInternal {
    private final FileCollection allInputFiles;
    private final FileCollection allSourceFiles;
    private final FileResolver resolver;
    private final String taskName;
    private final TaskMutator taskMutator;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<PropertySpec> filePropertiesInternal = Lists.newArrayList();
    private SortedSet<TaskInputFilePropertySpec> fileProperties;

    public DefaultTaskInputs(FileResolver resolver, String taskName, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.taskName = taskName;
        this.taskMutator = taskMutator;
        this.allInputFiles = new TaskInputUnionFileCollection("task '" + taskName + "' input files", false);
        this.allSourceFiles = new TaskInputUnionFileCollection("task '" + taskName + "' source files", true);
    }

    @Override
    public boolean getHasInputs() {
        return !this.filePropertiesInternal.isEmpty() || !this.properties.isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.allInputFiles;
    }

    @Override
    public SortedSet<TaskInputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            TaskPropertyUtils.ensurePropertiesHaveNames(this.filePropertiesInternal);
            this.fileProperties = TaskPropertyUtils.collectFileProperties("input", this.filePropertiesInternal);
        }
        return this.fileProperties;
    }

    @Override
    public TaskInputFilePropertyBuilder files(final Object ... paths) {
        return this.taskMutator.mutate("TaskInputs.files(Object...)", new Callable<TaskInputFilePropertyBuilder>(){

            @Override
            public TaskInputFilePropertyBuilder call() {
                return DefaultTaskInputs.this.addSpec(paths);
            }
        });
    }

    @Override
    public TaskInputFilePropertyBuilder file(final Object path) {
        return this.taskMutator.mutate("TaskInputs.file(Object)", new Callable<TaskInputFilePropertyBuilder>(){

            @Override
            public TaskInputFilePropertyBuilder call() {
                return DefaultTaskInputs.this.addSpec(path);
            }
        });
    }

    @Override
    public TaskInputFilePropertyBuilder dir(final Object dirPath) {
        return this.taskMutator.mutate("TaskInputs.dir(Object)", new Callable<TaskInputFilePropertyBuilder>(){

            @Override
            public TaskInputFilePropertyBuilder call() {
                return DefaultTaskInputs.this.addSpec(DefaultTaskInputs.this.resolver.resolveFilesAsTree(dirPath));
            }
        });
    }

    @Override
    public boolean getHasSourceFiles() {
        for (PropertySpec propertySpec : this.filePropertiesInternal) {
            if (!propertySpec.isSkipWhenEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.allSourceFiles;
    }

    @Override
    public TaskInputs source(final Object ... paths) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputs.source(Object...)", (String)"Please use TaskInputs.files(Object...).skipWhenEmpty() instead.");
        this.taskMutator.mutate("TaskInputs.source(Object...)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.addSpec(paths, true);
            }
        });
        return this;
    }

    @Override
    public TaskInputs source(final Object path) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputs.source(Object)", (String)"Please use TaskInputs.file(Object).skipWhenEmpty() instead.");
        this.taskMutator.mutate("TaskInputs.source(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.addSpec(path, true);
            }
        });
        return this;
    }

    @Override
    public TaskInputs sourceDir(final Object path) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputs.sourceDir(Object)", (String)"Please use TaskInputs.dir(Object).skipWhenEmpty() instead.");
        this.taskMutator.mutate("TaskInputs.sourceDir(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.addSpec(DefaultTaskInputs.this.resolver.resolveFilesAsTree(path), true);
            }
        });
        return this;
    }

    private TaskInputFilePropertyBuilder addSpec(Object paths) {
        return this.addSpec(paths, false);
    }

    private TaskInputFilePropertyBuilder addSpec(Object paths, boolean skipWhenEmpty) {
        PropertySpec spec = new PropertySpec(this.taskName, skipWhenEmpty, this.resolver, paths);
        this.filePropertiesInternal.add(spec);
        return spec;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> actualProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object value = this.prepareValue(entry.getValue());
            actualProperties.put(entry.getKey(), value);
        }
        return actualProperties;
    }

    private Object prepareValue(Object value) {
        while (value instanceof Callable) {
            Callable callable = (Callable)value;
            value = GUtil.uncheckedCall((Callable)callable);
        }
        if (value instanceof FileCollection) {
            FileCollection fileCollection = (FileCollection)value;
            return fileCollection.getFiles();
        }
        return DefaultTaskInputs.avoidGString(value);
    }

    private static Object avoidGString(Object value) {
        return value instanceof GString ? value.toString() : value;
    }

    @Override
    public TaskInputs property(final String name, final Object value) {
        this.taskMutator.mutate("TaskInputs.property(String, Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.properties.put(name, value);
            }
        });
        return this;
    }

    @Override
    public TaskInputs properties(final Map<String, ?> newProps) {
        this.taskMutator.mutate("TaskInputs.properties(Map)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.properties.putAll(newProps);
            }
        });
        return this;
    }

    private class TaskInputUnionFileCollection
    extends CompositeFileCollection {
        private final boolean skipWhenEmptyOnly;
        private final String displayName;

        public TaskInputUnionFileCollection(String displayName, boolean skipWhenEmptyOnly) {
            this.displayName = displayName;
            this.skipWhenEmptyOnly = skipWhenEmptyOnly;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void visitContents(FileCollectionResolveContext context) {
            for (PropertySpec fileProperty : DefaultTaskInputs.this.filePropertiesInternal) {
                if (this.skipWhenEmptyOnly && !fileProperty.isSkipWhenEmpty()) continue;
                context.add(fileProperty.getPropertyFiles());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertySpec
    extends AbstractTaskPropertyBuilder
    implements TaskInputFilePropertySpec,
    TaskInputFilePropertyBuilder {
        private final TaskPropertyFileCollection files;
        private boolean skipWhenEmpty;
        private boolean optional;

        public PropertySpec(String taskName, boolean skipWhenEmpty, FileResolver resolver, Object paths) {
            this.files = new TaskPropertyFileCollection(taskName, "input", this, resolver, paths);
            this.skipWhenEmpty = skipWhenEmpty;
        }

        @Override
        public FileCollection getPropertyFiles() {
            return this.files;
        }

        @Override
        public TaskInputFilePropertyBuilder withPropertyName(String propertyName) {
            this.setPropertyName(propertyName);
            return this;
        }

        public boolean isSkipWhenEmpty() {
            return this.skipWhenEmpty;
        }

        @Override
        public TaskInputFilePropertyBuilder skipWhenEmpty(boolean skipWhenEmpty) {
            this.skipWhenEmpty = skipWhenEmpty;
            return this;
        }

        @Override
        public TaskInputFilePropertyBuilder skipWhenEmpty() {
            return this.skipWhenEmpty(true);
        }

        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public TaskInputFilePropertyBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        @Override
        public TaskInputFilePropertyBuilder optional() {
            return this.optional(true);
        }

        private TaskInputs getTaskInputs(String method) {
            DeprecationLogger.nagUserOfDiscontinuedMethod((String)("chaining of the " + method), (String)String.format("Please use the %s method on TaskInputs directly instead.", method));
            return DefaultTaskInputs.this;
        }

        @Override
        public boolean getHasInputs() {
            return this.getTaskInputs("getHasInputs()").getHasInputs();
        }

        @Override
        public FileCollection getFiles() {
            return this.getTaskInputs("getFiles()").getFiles();
        }

        @Override
        public TaskInputFilePropertyBuilder files(Object ... paths) {
            return this.getTaskInputs("files(Object...)").files(paths);
        }

        @Override
        public TaskInputFilePropertyBuilder file(Object path) {
            return this.getTaskInputs("file(Object)").file(path);
        }

        @Override
        public TaskInputFilePropertyBuilder dir(Object dirPath) {
            return this.getTaskInputs("dir(Object)").dir(dirPath);
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.getTaskInputs("getProperties()").getProperties();
        }

        @Override
        public TaskInputs property(String name, Object value) {
            return this.getTaskInputs("property(String, Object)").property(name, value);
        }

        @Override
        public TaskInputs properties(Map<String, ?> properties) {
            return this.getTaskInputs("properties(Map)").properties(properties);
        }

        @Override
        public boolean getHasSourceFiles() {
            return this.getTaskInputs("getHasSourceFiles()").getHasSourceFiles();
        }

        @Override
        public FileCollection getSourceFiles() {
            return this.getTaskInputs("getSourceFiles()").getSourceFiles();
        }

        @Override
        @Deprecated
        public TaskInputs source(Object ... paths) {
            return this.getTaskInputs("source(Object...)").source(paths);
        }

        @Override
        @Deprecated
        public TaskInputs source(Object path) {
            return this.getTaskInputs("source(Object)").source(path);
        }

        @Override
        @Deprecated
        public TaskInputs sourceDir(Object path) {
            return this.getTaskInputs("sourceDir(Object)").sourceDir(path);
        }

        @Override
        public int compareTo(TaskPropertySpec o) {
            return this.getPropertyName().compareTo(o.getPropertyName());
        }
    }
}

