/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskClassValidator;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.TaskPropertyValue;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPropertyInfo
implements TaskPropertyActionContext {
    private static final ValidationAction NO_OP_VALIDATION_ACTION = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
        }
    };
    private static final TaskPropertyValue NO_OP_VALUE = new TaskPropertyValue(){

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void checkNotNull(Collection<String> messages) {
        }

        @Override
        public void checkValid(Collection<String> messages) {
        }
    };
    private static final UpdateAction NO_OP_CONFIGURATION_ACTION = new UpdateAction(){

        @Override
        public void update(TaskInternal task, Callable<Object> futureValue) {
        }
    };
    private final TaskClassValidator validator;
    private final TaskPropertyInfo parent;
    private final String propertyName;
    private final Method method;
    private final List<Annotation> annotations = Lists.newLinkedList();
    private ValidationAction validationAction = NO_OP_VALIDATION_ACTION;
    private ValidationAction notNullValidator = NO_OP_VALIDATION_ACTION;
    private UpdateAction configureAction = NO_OP_CONFIGURATION_ACTION;
    private boolean validationRequired;
    private Field instanceVariableField;

    TaskPropertyInfo(TaskClassValidator validator, TaskPropertyInfo parent, String propertyName, Method method, Field instanceVariableField) {
        this.validator = validator;
        this.parent = parent;
        this.propertyName = propertyName;
        this.method = method;
        this.instanceVariableField = instanceVariableField;
    }

    public String toString() {
        return this.propertyName;
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    public Field getInstanceVariableField() {
        return this.instanceVariableField;
    }

    public void setInstanceVariableField(Field instanceVariableField) {
        this.instanceVariableField = instanceVariableField;
    }

    @Override
    public Class<?> getType() {
        return this.instanceVariableField != null ? this.instanceVariableField.getType() : this.method.getReturnType();
    }

    public void addAnnotations(Annotation ... annotations) {
        Collections.addAll(this.annotations, annotations);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotationType.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setValidationAction(ValidationAction action) {
        this.validationAction = action;
    }

    public UpdateAction getConfigureAction() {
        return this.configureAction;
    }

    @Override
    public void setConfigureAction(UpdateAction action) {
        this.configureAction = action;
    }

    public void setNotNullValidator(ValidationAction notNullValidator) {
        this.notNullValidator = notNullValidator;
    }

    @Override
    public void attachActions(Class<?> type) {
        this.validator.attachActions(this, type);
    }

    public void attachActions(PropertyAnnotationHandler handler) {
        if (handler.attachActions(this)) {
            this.validationRequired = true;
        }
    }

    public boolean isValidationRequired() {
        return this.validationRequired;
    }

    public TaskPropertyValue getValue(Object rootObject) {
        Object bean = rootObject;
        if (this.parent != null) {
            TaskPropertyValue parentValue = this.parent.getValue(rootObject);
            if (parentValue.getValue() == null) {
                return NO_OP_VALUE;
            }
            bean = parentValue.getValue();
        }
        final Object finalBean = bean;
        final Object value = DeprecationLogger.whileDisabled((Factory)new Factory<Object>(){

            public Object create() {
                return JavaReflectionUtil.method((Object)finalBean, Object.class, (Method)TaskPropertyInfo.this.method).invoke(finalBean, new Object[0]);
            }
        });
        return new TaskPropertyValue(){

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public void checkNotNull(Collection<String> messages) {
                TaskPropertyInfo.this.notNullValidator.validate(TaskPropertyInfo.this.propertyName, value, messages);
            }

            @Override
            public void checkValid(Collection<String> messages) {
                if (value != null) {
                    TaskPropertyInfo.this.validationAction.validate(TaskPropertyInfo.this.propertyName, value, messages);
                }
            }
        };
    }
}

