/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.tasks.cache.DefaultTaskCacheKeyBuilder;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskCacheKeyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskExecution {
    private String taskClass;
    private HashCode taskClassLoaderHash;
    private HashCode taskActionsClassLoaderHash;
    private Map<String, Object> inputProperties;
    private Set<String> outputFiles;

    public Set<String> getOutputFiles() {
        return this.outputFiles;
    }

    public void setOutputFiles(Set<String> outputFiles) {
        this.outputFiles = outputFiles;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public HashCode getTaskClassLoaderHash() {
        return this.taskClassLoaderHash;
    }

    public void setTaskClassLoaderHash(HashCode taskClassLoaderHash) {
        this.taskClassLoaderHash = taskClassLoaderHash;
    }

    public HashCode getTaskActionsClassLoaderHash() {
        return this.taskActionsClassLoaderHash;
    }

    public void setTaskActionsClassLoaderHash(HashCode taskActionsClassLoaderHash) {
        this.taskActionsClassLoaderHash = taskActionsClassLoaderHash;
    }

    public Map<String, Object> getInputProperties() {
        return this.inputProperties;
    }

    public void setInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = inputProperties;
    }

    public abstract Map<String, FileCollectionSnapshot> getOutputFilesSnapshot();

    public abstract void setOutputFilesSnapshot(Map<String, FileCollectionSnapshot> var1);

    public abstract Map<String, FileCollectionSnapshot> getInputFilesSnapshot();

    public abstract void setInputFilesSnapshot(Map<String, FileCollectionSnapshot> var1);

    public abstract FileCollectionSnapshot getDiscoveredInputFilesSnapshot();

    public abstract void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot var1);

    public TaskCacheKey calculateCacheKey() {
        DefaultTaskCacheKeyBuilder builder = new DefaultTaskCacheKeyBuilder();
        builder.putString(this.taskClass);
        builder.putHashCode(this.taskClassLoaderHash);
        builder.putHashCode(this.taskActionsClassLoaderHash);
        for (Map.Entry entry : TaskExecution.sortEntries(this.inputProperties.entrySet())) {
            builder.putString(entry.getKey());
            Object value = entry.getValue();
            TaskExecution.appendToCacheKey(builder, value);
        }
        for (Map.Entry entry : TaskExecution.sortEntries(this.getInputFilesSnapshot().entrySet())) {
            builder.putString(entry.getKey());
            FileCollectionSnapshot snapshot = (FileCollectionSnapshot)entry.getValue();
            snapshot.appendToCacheKey(builder);
        }
        return builder.build();
    }

    private static <T> List<Map.Entry<String, T>> sortEntries(Set<Map.Entry<String, T>> entries) {
        ArrayList sortedEntries = Lists.newArrayList(entries);
        Collections.sort(sortedEntries, new Comparator<Map.Entry<String, T>>(){

            @Override
            public int compare(Map.Entry<String, T> o1, Map.Entry<String, T> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return sortedEntries;
    }

    private static void appendToCacheKey(TaskCacheKeyBuilder builder, Object value) {
        if (value == null) {
            builder.putString("$NULL");
            return;
        }
        if (value.getClass().isArray()) {
            builder.putString("Array");
            int len = Array.getLength(value);
            for (int idx = 0; idx < len; ++idx) {
                builder.putInt(idx);
                TaskExecution.appendToCacheKey(builder, Array.get(value, idx));
            }
            return;
        }
        if (value instanceof Iterable) {
            builder.putString("Iterable");
            int idx = 0;
            for (Object elem : (Iterable)value) {
                builder.putInt(idx);
                TaskExecution.appendToCacheKey(builder, elem);
                ++idx;
            }
            return;
        }
        if (value instanceof Map) {
            builder.putString("Map");
            int idx = 0;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                builder.putInt(idx);
                TaskExecution.appendToCacheKey(builder, entry.getKey());
                TaskExecution.appendToCacheKey(builder, entry.getValue());
                ++idx;
            }
            return;
        }
        if (value instanceof Boolean) {
            builder.putBoolean((Boolean)value);
        } else if (value instanceof Integer) {
            builder.putInt((Integer)value);
        } else if (value instanceof Short) {
            builder.putInt(((Short)value).shortValue());
        } else if (value instanceof Byte) {
            builder.putInt(((Byte)value).byteValue());
        } else if (value instanceof Double) {
            builder.putDouble((Double)value);
        } else if (value instanceof Float) {
            builder.putDouble(((Float)value).floatValue());
        } else if (value instanceof BigInteger) {
            builder.putBytes(((BigInteger)value).toByteArray());
        } else if (value instanceof CharSequence) {
            builder.putString((CharSequence)value);
        } else if (value instanceof Enum) {
            builder.putString(value.getClass().getName());
            builder.putString(((Enum)value).name());
        } else {
            byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)value));
            builder.putBytes(bytes);
        }
    }
}

