/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotImpl;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotSerializer;
import org.gradle.api.internal.tasks.cache.TaskCacheKeyBuilder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileCollectionSnapshotter snapshotter;
    private final StringInterner stringInterner;

    public OutputFilesCollectionSnapshotter(FileCollectionSnapshotter snapshotter, StringInterner stringInterner) {
        this.snapshotter = snapshotter;
        this.stringInterner = stringInterner;
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        DefaultSerializerRegistry nested = new DefaultSerializerRegistry();
        this.snapshotter.registerSerializers((SerializerRegistry)nested);
        registry.register(OutputFilesSnapshot.class, (Serializer)new OutputFilesSnapshotSerializer((Serializer<FileCollectionSnapshot>)nested.build(FileCollectionSnapshot.class), this.stringInterner));
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new OutputFilesSnapshot(Collections.<String, Boolean>emptyMap(), this.snapshotter.emptySnapshot());
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection files, boolean allowReuse) {
        return new OutputFilesSnapshot(this.getRoots(files), this.snapshotter.snapshot(files, allowReuse));
    }

    private Map<String, Boolean> getRoots(FileCollection files) {
        HashMap<String, Boolean> roots = new HashMap<String, Boolean>();
        for (File file : files.getFiles()) {
            roots.put(this.stringInterner.intern(file.getAbsolutePath()), file.exists());
        }
        return roots;
    }

    public OutputFilesSnapshot createOutputSnapshot(FileCollectionSnapshot afterPreviousExecution, FileCollectionSnapshot beforeExecution, FileCollectionSnapshot afterExecution, FileCollection roots) {
        FileCollectionSnapshot filesSnapshot;
        if (!beforeExecution.getSnapshots().isEmpty() && !afterExecution.getSnapshots().isEmpty()) {
            Map<String, IncrementalFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
            HashMap previousSnapshots = afterPreviousExecution != null ? afterPreviousExecution.getSnapshots() : new HashMap();
            ArrayList<Map.Entry<String, IncrementalFileSnapshot>> newEntries = new ArrayList<Map.Entry<String, IncrementalFileSnapshot>>(afterExecution.getSnapshots().size());
            for (Map.Entry<String, IncrementalFileSnapshot> entry : afterExecution.getSnapshots().entrySet()) {
                String string = entry.getKey();
                IncrementalFileSnapshot otherFile = beforeSnapshots.get(string);
                if (otherFile != null && entry.getValue().isContentAndMetadataUpToDate(otherFile) && !previousSnapshots.containsKey(string)) continue;
                newEntries.add(entry);
            }
            if (newEntries.size() == afterExecution.getSnapshots().size()) {
                filesSnapshot = afterExecution;
            } else {
                HashMap<String, IncrementalFileSnapshot> newSnapshots = new HashMap<String, IncrementalFileSnapshot>(newEntries.size());
                for (Map.Entry entry : newEntries) {
                    newSnapshots.put((String)entry.getKey(), (IncrementalFileSnapshot)entry.getValue());
                }
                filesSnapshot = new FileCollectionSnapshotImpl(newSnapshots);
            }
        } else {
            filesSnapshot = afterExecution;
        }
        if (filesSnapshot instanceof OutputFilesSnapshot) {
            filesSnapshot = ((OutputFilesSnapshot)filesSnapshot).filesSnapshot;
        }
        return new OutputFilesSnapshot(this.getRoots(roots), filesSnapshot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OutputFilesSnapshot
    implements FileCollectionSnapshot {
        final Map<String, Boolean> roots;
        final FileCollectionSnapshot filesSnapshot;

        public OutputFilesSnapshot(Map<String, Boolean> roots, FileCollectionSnapshot filesSnapshot) {
            this.roots = roots;
            this.filesSnapshot = filesSnapshot;
        }

        @Override
        public Collection<File> getFiles() {
            return this.filesSnapshot.getFiles();
        }

        @Override
        public Map<String, IncrementalFileSnapshot> getSnapshots() {
            return this.filesSnapshot.getSnapshots();
        }

        @Override
        public FilesSnapshotSet getSnapshot() {
            return this.filesSnapshot.getSnapshot();
        }

        @Override
        public Collection<Long> getTreeSnapshotIds() {
            return this.filesSnapshot.getTreeSnapshotIds();
        }

        @Override
        public boolean isEmpty() {
            return this.filesSnapshot.isEmpty();
        }

        @Override
        public Iterator<TaskStateChange> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, String fileType, Set<FileCollectionSnapshot.ChangeFilter> filters) {
            OutputFilesSnapshot other = (OutputFilesSnapshot)oldSnapshot;
            Iterator<TaskStateChange> rootFileIdIterator = this.iterateRootFileIdChanges(other, fileType);
            Iterator<TaskStateChange> fileIterator = this.filesSnapshot.iterateContentChangesSince(other.filesSnapshot, fileType, filters);
            return Iterators.concat(rootFileIdIterator, fileIterator);
        }

        private Iterator<TaskStateChange> iterateRootFileIdChanges(OutputFilesSnapshot other, final String fileType) {
            HashMap<String, Boolean> added = new HashMap<String, Boolean>(this.roots);
            added.keySet().removeAll(other.roots.keySet());
            final Iterator addedIterator = added.keySet().iterator();
            HashMap<String, Boolean> removed = new HashMap<String, Boolean>(other.roots);
            removed.keySet().removeAll(this.roots.keySet());
            final Iterator removedIterator = removed.keySet().iterator();
            HashSet<String> changed = new HashSet<String>();
            for (Map.Entry<String, Boolean> current : this.roots.entrySet()) {
                Boolean otherValue = other.roots.get(current.getKey());
                if (otherValue == null || !otherValue.booleanValue() || otherValue.equals(current.getValue())) continue;
                changed.add(current.getKey());
            }
            final Iterator changedIterator = changed.iterator();
            return new AbstractIterator<TaskStateChange>(){

                protected TaskStateChange computeNext() {
                    if (addedIterator.hasNext()) {
                        return new FileChange((String)addedIterator.next(), ChangeType.ADDED, fileType);
                    }
                    if (removedIterator.hasNext()) {
                        return new FileChange((String)removedIterator.next(), ChangeType.REMOVED, fileType);
                    }
                    if (changedIterator.hasNext()) {
                        return new FileChange((String)changedIterator.next(), ChangeType.MODIFIED, fileType);
                    }
                    return (TaskStateChange)this.endOfData();
                }
            };
        }

        @Override
        public void appendToCacheKey(TaskCacheKeyBuilder builder) {
            this.filesSnapshot.appendToCacheKey(builder);
        }
    }
}

