/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.EOFException;
import org.gradle.api.internal.changedetection.state.DirSnapshot;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IncrementalFileSnapshotSerializer
implements Serializer<IncrementalFileSnapshot> {
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

    IncrementalFileSnapshotSerializer() {
    }

    public IncrementalFileSnapshot read(Decoder decoder) throws EOFException, Exception {
        IncrementalFileSnapshot incrementalFileSnapshot;
        byte fileSnapshotKind = decoder.readByte();
        if (fileSnapshotKind == 1) {
            incrementalFileSnapshot = DirSnapshot.getInstance();
        } else if (fileSnapshotKind == 2) {
            incrementalFileSnapshot = MissingFileSnapshot.getInstance();
        } else if (fileSnapshotKind == 3) {
            incrementalFileSnapshot = new FileHashSnapshot(this.hashCodeSerializer.read(decoder));
        } else {
            throw new RuntimeException("Unable to read serialized file collection snapshot. Unrecognized value found in the data stream.");
        }
        return incrementalFileSnapshot;
    }

    public void write(Encoder encoder, IncrementalFileSnapshot incrementalFileSnapshot) throws Exception {
        if (incrementalFileSnapshot instanceof DirSnapshot) {
            encoder.writeByte((byte)1);
        } else if (incrementalFileSnapshot instanceof MissingFileSnapshot) {
            encoder.writeByte((byte)2);
        } else if (incrementalFileSnapshot instanceof FileHashSnapshot) {
            encoder.writeByte((byte)3);
            this.hashCodeSerializer.write(encoder, ((FileHashSnapshot)incrementalFileSnapshot).getHash());
        }
    }
}

