/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.HashCode;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;

class FileHashSnapshot
implements IncrementalFileSnapshot {
    private final HashCode hash;
    private final transient long lastModified;

    public FileHashSnapshot(HashCode hash) {
        this(hash, 0L);
    }

    public FileHashSnapshot(HashCode hash, long lastModified) {
        this.hash = hash;
        this.lastModified = lastModified;
    }

    public boolean isContentUpToDate(IncrementalFileSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return this.hash.equals((Object)other.hash);
    }

    public boolean isContentAndMetadataUpToDate(IncrementalFileSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return this.lastModified == other.lastModified && this.hash.equals((Object)other.hash);
    }

    public String toString() {
        return this.hash.toString();
    }

    public HashCode getHash() {
        return this.hash;
    }
}

