/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotImpl;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshot;
import org.gradle.api.internal.changedetection.state.VisitedTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.cache.CacheAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    protected final FileSnapshotter snapshotter;
    protected final StringInterner stringInterner;
    protected final FileResolver fileResolver;
    protected CacheAccess cacheAccess;

    public AbstractFileCollectionSnapshotter(FileSnapshotter snapshotter, CacheAccess cacheAccess, StringInterner stringInterner, FileResolver fileResolver) {
        this.snapshotter = snapshotter;
        this.cacheAccess = cacheAccess;
        this.stringInterner = stringInterner;
        this.fileResolver = fileResolver;
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new FileCollectionSnapshotImpl(Collections.<String, IncrementalFileSnapshot>emptyMap());
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection input, boolean allowReuse) {
        final LinkedList fileTreeElements = Lists.newLinkedList();
        final ArrayList missingFiles = Lists.newArrayList();
        this.visitFiles(input, fileTreeElements, missingFiles, allowReuse);
        if (fileTreeElements.isEmpty() && missingFiles.isEmpty()) {
            return this.emptySnapshot();
        }
        final ArrayList<TreeSnapshot> treeSnapshots = new ArrayList<TreeSnapshot>();
        this.cacheAccess.useCache("Create file snapshot", new Runnable(){

            public void run() {
                ArrayList<VisitedTree> nonShareableTrees = new ArrayList<VisitedTree>();
                for (VisitedTree tree : fileTreeElements) {
                    if (tree.isShareable()) {
                        treeSnapshots.add(tree.maybeCreateSnapshot(AbstractFileCollectionSnapshotter.this.snapshotter, AbstractFileCollectionSnapshotter.this.stringInterner));
                        continue;
                    }
                    nonShareableTrees.add(tree);
                }
                if (!nonShareableTrees.isEmpty() || !missingFiles.isEmpty()) {
                    VisitedTree nonShareableTree = AbstractFileCollectionSnapshotter.this.createJoinedTree(nonShareableTrees, missingFiles);
                    treeSnapshots.add(nonShareableTree.maybeCreateSnapshot(AbstractFileCollectionSnapshotter.this.snapshotter, AbstractFileCollectionSnapshotter.this.stringInterner));
                }
            }
        });
        return new FileCollectionSnapshotImpl(treeSnapshots);
    }

    abstract VisitedTree createJoinedTree(List<VisitedTree> var1, Collection<File> var2);

    protected abstract void visitFiles(FileCollection var1, List<VisitedTree> var2, List<File> var3, boolean var4);
}

