/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractNamedFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesTaskStateChanges
extends AbstractNamedFileSnapshotTaskStateChanges {
    private static final EnumSet<FileCollectionSnapshot.ChangeFilter> IGNORE_ADDED_FILES = EnumSet.of(FileCollectionSnapshot.ChangeFilter.IgnoreAddedFiles);

    public OutputFilesTaskStateChanges(TaskExecution previous, TaskExecution current, TaskInternal task, OutputFilesCollectionSnapshotter snapshotter) {
        super(task.getName(), previous, current, snapshotter, false, "Output", task.getOutputs().getFileProperties());
    }

    @Override
    public Map<String, FileCollectionSnapshot> getPrevious() {
        return this.previous.getOutputFilesSnapshot();
    }

    @Override
    protected Set<FileCollectionSnapshot.ChangeFilter> getFileChangeFilters() {
        return IGNORE_ADDED_FILES;
    }

    @Override
    public void saveCurrent() {
        Map<String, FileCollectionSnapshot> outputFilesAfter = OutputFilesTaskStateChanges.buildSnapshots(this.getTaskName(), this.getSnapshotter(), this.getTitle(), this.getFileProperties(), this.isAllowSnapshotReuse());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TaskFilePropertySpec propertySpec : this.fileProperties) {
            String propertyName = propertySpec.getPropertyName();
            FileCollection roots = propertySpec.getPropertyFiles();
            FileCollectionSnapshot beforeExecution = this.getCurrent().get(propertyName);
            FileCollectionSnapshot afterExecution = outputFilesAfter.get(propertyName);
            FileCollectionSnapshot afterPreviousExecution = this.getSnapshotAfterPreviousExecution(propertyName);
            OutputFilesCollectionSnapshotter.OutputFilesSnapshot outputSnapshot = this.getSnapshotter().createOutputSnapshot(afterPreviousExecution, beforeExecution, afterExecution, roots);
            builder.put((Object)propertyName, (Object)outputSnapshot);
        }
        this.current.setOutputFilesSnapshot((Map<String, FileCollectionSnapshot>)builder.build());
    }

    private FileCollectionSnapshot getSnapshotAfterPreviousExecution(String propertyName) {
        FileCollectionSnapshot afterPreviousExecution;
        Map<String, FileCollectionSnapshot> previousSnapshots;
        if (this.previous != null && (previousSnapshots = this.previous.getOutputFilesSnapshot()) != null && (afterPreviousExecution = previousSnapshots.get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return this.getSnapshotter().emptySnapshot();
    }

    @Override
    protected OutputFilesCollectionSnapshotter getSnapshotter() {
        return (OutputFilesCollectionSnapshotter)super.getSnapshotter();
    }
}

