/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.Collections;
import java.util.Iterator;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFileSnapshotTaskStateChanges
implements TaskStateChanges {
    private final String taskName;

    protected AbstractFileSnapshotTaskStateChanges(String taskName) {
        this.taskName = taskName;
    }

    protected abstract String getInputFileType();

    protected abstract FileCollectionSnapshot getPrevious();

    protected abstract FileCollectionSnapshot getCurrent();

    protected abstract void saveCurrent();

    protected Iterator<TaskStateChange> getChanges(String fileType) {
        return this.getCurrent().iterateContentChangesSince(this.getPrevious(), fileType, Collections.<FileCollectionSnapshot.ChangeFilter>emptySet());
    }

    protected FileCollectionSnapshot createSnapshot(FileCollectionSnapshotter snapshotter, FileCollection fileCollection) {
        try {
            return snapshotter.snapshot(fileCollection, this.isAllowSnapshotReuse());
        }
        catch (UncheckedIOException e) {
            throw new UncheckedIOException(String.format("Failed to capture snapshot of %s files for task '%s' during up-to-date check.", this.getInputFileType().toLowerCase(), this.taskName), (Throwable)e);
        }
    }

    protected boolean isAllowSnapshotReuse() {
        return true;
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.getPrevious() == null) {
            return Collections.singleton(new DescriptiveChange(this.getInputFileType() + " file history is not available.", new Object[0])).iterator();
        }
        return this.getChanges(this.getInputFileType());
    }

    @Override
    public void snapshotAfterTask() {
        this.saveCurrent();
    }
}

