/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.gradle.api.Action;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.logging.ConsoleOutput;
import org.gradle.logging.internal.AnsiConsole;
import org.gradle.logging.internal.OutputEventRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleConfigureAction
implements Action<OutputEventRenderer> {
    public void execute(OutputEventRenderer renderer) {
        ConsoleOutput consoleOutput = renderer.getConsoleOutput();
        if (consoleOutput == ConsoleOutput.Plain) {
            return;
        }
        ConsoleDetector consoleDetector = (ConsoleDetector)NativeServices.getInstance().get(ConsoleDetector.class);
        ConsoleMetaData consoleMetaData = consoleDetector.getConsole();
        boolean force = false;
        if (consoleMetaData == null) {
            if (consoleOutput == ConsoleOutput.Auto) {
                return;
            }
            assert (consoleOutput == ConsoleOutput.Rich);
            consoleMetaData = new FallbackConsoleMetaData();
            force = true;
        }
        boolean stdOutIsTerminal = consoleMetaData.isStdOut();
        boolean stdErrIsTerminal = consoleMetaData.isStdErr();
        if (stdOutIsTerminal) {
            OutputStream originalStdOut = renderer.getOriginalStdOut();
            OutputStreamWriter outStr = new OutputStreamWriter(force ? originalStdOut : org.fusesource.jansi.AnsiConsole.wrapOutputStream((OutputStream)originalStdOut));
            AnsiConsole console = new AnsiConsole(outStr, outStr, renderer.getColourMap(), force);
            renderer.addConsole(console, true, stdErrIsTerminal, consoleMetaData);
        } else if (stdErrIsTerminal) {
            OutputStream originalStdErr = renderer.getOriginalStdErr();
            OutputStreamWriter errStr = new OutputStreamWriter(force ? originalStdErr : org.fusesource.jansi.AnsiConsole.wrapOutputStream((OutputStream)originalStdErr));
            AnsiConsole console = new AnsiConsole(errStr, errStr, renderer.getColourMap(), force);
            renderer.addConsole(console, false, true, consoleMetaData);
        }
    }
}

