/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.classloading.MemoryLeakPrevention;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.ClassPathToClassLoaderCache;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.Jvm;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIsolatedAntBuilder
implements IsolatedAntBuilder {
    private static final Logger LOG = Logging.getLogger(DefaultIsolatedAntBuilder.class);
    private static final String CORE_GRADLE_LOADER = "Gradle Core";
    private static final String ANT_GRADLE_LOADER = "Ant loader";
    private static final Set<Finalizer> FINALIZERS = Sets.newConcurrentHashSet();
    private static final ReferenceQueue<DefaultIsolatedAntBuilder> FINALIZER_REFQUEUE = new ReferenceQueue();
    private final ClassLoader baseAntLoader;
    private final ClassPath libClasspath;
    private final ClassLoader gradleLoader;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderFactory classLoaderFactory;
    private final MemoryLeakPrevention gradleToIsolatedLeakPrevention;
    private final MemoryLeakPrevention antToGradleLeakPrevention;
    private final ClassPathToClassLoaderCache classLoaderCache;

    public DefaultIsolatedAntBuilder(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory) {
        this.classPathRegistry = classPathRegistry;
        this.classLoaderFactory = classLoaderFactory;
        this.libClasspath = new DefaultClassPath(new File[0]);
        this.classLoaderCache = new ClassPathToClassLoaderCache();
        ArrayList antClasspath = Lists.newArrayList((Iterable)classPathRegistry.getClassPath("ANT").getAsFiles());
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            antClasspath.add(toolsJar);
        }
        ClassLoader antLoader = classLoaderFactory.createIsolatedClassLoader((ClassPath)new DefaultClassPath((Iterable)antClasspath));
        FilteringClassLoader loggingLoader = new FilteringClassLoader(this.getClass().getClassLoader());
        loggingLoader.allowPackage("org.slf4j");
        loggingLoader.allowPackage("org.apache.commons.logging");
        loggingLoader.allowPackage("org.apache.log4j");
        loggingLoader.allowClass(Logger.class);
        loggingLoader.allowClass(LogLevel.class);
        this.baseAntLoader = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{antLoader, loggingLoader}));
        ClassPath gradleCoreUrls = classPathRegistry.getClassPath("GRADLE_CORE");
        gradleCoreUrls = gradleCoreUrls.plus(classPathRegistry.getClassPath("GROOVY"));
        gradleCoreUrls = gradleCoreUrls.plus(classPathRegistry.getClassPath("GRADLE_BASE_SERVICES"));
        this.gradleLoader = new URLClassLoader(gradleCoreUrls.getAsURLArray(), this.baseAntLoader);
        this.gradleToIsolatedLeakPrevention = new MemoryLeakPrevention(CORE_GRADLE_LOADER, this.getClass().getClassLoader(), null);
        this.antToGradleLeakPrevention = new MemoryLeakPrevention(ANT_GRADLE_LOADER, this.gradleLoader, gradleCoreUrls);
        this.gradleToIsolatedLeakPrevention.prepare(new ClassLoader[0]);
        this.antToGradleLeakPrevention.prepare(new ClassLoader[0]);
        FINALIZERS.add(new Finalizer(this, FINALIZER_REFQUEUE));
    }

    protected DefaultIsolatedAntBuilder(DefaultIsolatedAntBuilder copy, Iterable<File> libClasspath) {
        this.classPathRegistry = copy.classPathRegistry;
        this.classLoaderFactory = copy.classLoaderFactory;
        this.baseAntLoader = copy.baseAntLoader;
        this.gradleLoader = copy.gradleLoader;
        this.libClasspath = new DefaultClassPath(libClasspath);
        this.gradleToIsolatedLeakPrevention = copy.gradleToIsolatedLeakPrevention;
        this.antToGradleLeakPrevention = copy.antToGradleLeakPrevention;
        this.classLoaderCache = copy.classLoaderCache;
    }

    public ClassPathToClassLoaderCache getClassLoaderCache() {
        return this.classLoaderCache;
    }

    @Override
    public IsolatedAntBuilder withClasspath(Iterable<File> classpath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Forking a new isolated ant builder for classpath : %s", classpath));
        }
        return new DefaultIsolatedAntBuilder(this, classpath);
    }

    @Override
    public void execute(final Closure antClosure) {
        this.classLoaderCache.withCachedClassLoader(this.libClasspath, this.gradleToIsolatedLeakPrevention, this.antToGradleLeakPrevention, (Factory<? extends ClassLoader>)new Factory<ClassLoader>(){

            public ClassLoader create() {
                return new URLClassLoader(DefaultIsolatedAntBuilder.this.libClasspath.getAsURLArray(), DefaultIsolatedAntBuilder.this.baseAntLoader);
            }
        }, (Action<? super CachedClassLoader>)new Action<CachedClassLoader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(CachedClassLoader cachedClassLoader) {
                ClassLoader classLoader = cachedClassLoader.getClassLoader();
                Object antBuilder = DefaultIsolatedAntBuilder.this.newInstanceOf("org.gradle.api.internal.project.ant.BasicAntBuilder");
                Object antLogger = DefaultIsolatedAntBuilder.this.newInstanceOf("org.gradle.api.internal.project.ant.AntLoggingAdapter");
                ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    DefaultIsolatedAntBuilder.this.configureAntBuilder(antBuilder, antLogger);
                    AntBuilderDelegate delegate = new AntBuilderDelegate(antBuilder, classLoader);
                    ConfigureUtil.configure(antClosure, delegate);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalLoader);
                    DefaultIsolatedAntBuilder.this.disposeBuilder(antBuilder, antLogger);
                }
            }
        });
    }

    private Object newInstanceOf(String className) {
        try {
            return this.gradleLoader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object getProject(Object antBuilder) throws Exception {
        return antBuilder.getClass().getMethod("getProject", new Class[0]).invoke(antBuilder, new Object[0]);
    }

    protected void configureAntBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method addBuildListener = projectClass.getDeclaredMethod("addBuildListener", buildListenerClass);
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            Method getBuildListeners = projectClass.getDeclaredMethod("getBuildListeners", new Class[0]);
            Vector listeners = (Vector)getBuildListeners.invoke(project, new Object[0]);
            removeBuildListener.invoke(project, listeners.get(0));
            addBuildListener.invoke(project, antLogger);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void disposeBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            removeBuildListener.invoke(project, antLogger);
            antBuilder.getClass().getDeclaredMethod("close", new Class[0]).invoke(antBuilder, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Thread finalizerThread = new Thread(){

            public void run() {
                while (!this.isInterrupted()) {
                    try {
                        Finalizer builder = (Finalizer)FINALIZER_REFQUEUE.remove();
                        FINALIZERS.remove(builder);
                        builder.cleanup();
                        builder.clear();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        };
        finalizerThread.setDaemon(true);
        finalizerThread.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Finalizer
    extends PhantomReference<DefaultIsolatedAntBuilder> {
        private final MemoryLeakPrevention gradleToIsolatedLeakPrevention;
        private final MemoryLeakPrevention antToGradleLeakPrevention;
        private final ClassPathToClassLoaderCache classLoaderCache;
        private final ClassLoader gradleLoader;

        public Finalizer(DefaultIsolatedAntBuilder referent, ReferenceQueue<? super DefaultIsolatedAntBuilder> q) {
            super(referent, q);
            this.gradleToIsolatedLeakPrevention = referent.gradleToIsolatedLeakPrevention;
            this.antToGradleLeakPrevention = referent.antToGradleLeakPrevention;
            this.classLoaderCache = referent.classLoaderCache;
            this.gradleLoader = referent.gradleLoader;
        }

        public void cleanup() {
            this.classLoaderCache.shutdown();
            this.gradleToIsolatedLeakPrevention.dispose(this.gradleLoader);
            this.antToGradleLeakPrevention.dispose(this.gradleLoader, this.getClass().getClassLoader());
        }
    }
}

