/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.gradle.api.internal.classloading.MemoryLeakPrevention;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.DefaultIsolatedAntBuilder;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cleanup
extends PhantomReference<CachedClassLoader> {
    private static final String ISOLATED_ANT_CLASS_LOADER = "Isolated Ant Classpath";
    private final ClassPath key;
    private final ClassLoader classLoader;
    private final MemoryLeakPrevention classLoaderLeakPrevention;
    private final MemoryLeakPrevention gradleToIsolatedLeakPrevention;
    private final MemoryLeakPrevention antToIsolatedLeakPrevention;

    public Cleanup(ClassPath classPath, CachedClassLoader cachedClassLoader, ReferenceQueue<CachedClassLoader> referenceQueue, ClassLoader classLoader, MemoryLeakPrevention antToIsolatedLeakPrevention, MemoryLeakPrevention gradleToIsolatedLeakPrevention) {
        super(cachedClassLoader, referenceQueue);
        MemoryLeakPrevention classLoaderLeakPrevention = new MemoryLeakPrevention(ISOLATED_ANT_CLASS_LOADER, classLoader, classPath);
        classLoaderLeakPrevention.prepare(new ClassLoader[0]);
        this.key = classPath;
        this.classLoader = classLoader;
        this.antToIsolatedLeakPrevention = antToIsolatedLeakPrevention;
        this.classLoaderLeakPrevention = classLoaderLeakPrevention;
        this.gradleToIsolatedLeakPrevention = gradleToIsolatedLeakPrevention;
    }

    public ClassPath getKey() {
        return this.key;
    }

    public void cleanup() {
        this.classLoaderLeakPrevention.dispose(this.classLoader, this.antToIsolatedLeakPrevention.getLeakingLoader(), DefaultIsolatedAntBuilder.class.getClassLoader());
        this.gradleToIsolatedLeakPrevention.dispose(this.classLoader);
        this.antToIsolatedLeakPrevention.dispose(this.classLoader);
    }
}

