/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gradle.api.Action;
import org.gradle.api.internal.classloading.MemoryLeakPrevention;
import org.gradle.api.internal.project.antbuilder.CacheEntry;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.Cleanup;
import org.gradle.api.internal.project.antbuilder.FinalizerThread;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathToClassLoaderCache {
    private static final Logger LOG = Logging.getLogger(ClassPathToClassLoaderCache.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<ClassPath, CacheEntry> cacheEntries = Maps.newConcurrentMap();
    private final FinalizerThread finalizerThread;
    private final Set<CachedClassLoader> inUseClassLoaders = Sets.newHashSet();

    public ClassPathToClassLoaderCache() {
        this.finalizerThread = new FinalizerThread(this.cacheEntries, this.lock);
        this.finalizerThread.start();
    }

    static String toCacheKey(ClassPath classPath) {
        return Joiner.on((String)":").join((Iterable)classPath.getAsURIs());
    }

    public void shutdown() {
        this.finalizerThread.exit();
    }

    public int size() {
        return this.cacheEntries.size();
    }

    public boolean isEmpty() {
        return this.cacheEntries.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withCachedClassLoader(ClassPath libClasspath, MemoryLeakPrevention gradleToIsolatedLeakPrevention, MemoryLeakPrevention antToGradleLeakPrevention, Factory<? extends ClassLoader> factory, Action<? super CachedClassLoader> action) {
        this.lock.readLock().lock();
        CacheEntry cacheEntry = this.cacheEntries.get(libClasspath);
        CachedClassLoader cachedClassLoader = this.maybeGet(cacheEntry);
        if (cachedClassLoader == null) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                cacheEntry = this.cacheEntries.get(libClasspath);
                cachedClassLoader = this.maybeGet(cacheEntry);
                if (cachedClassLoader == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Classloader cache miss for classpath : %s. Creating classloader.", libClasspath.getAsURIs()));
                    }
                    ClassLoader classLoader = (ClassLoader)factory.create();
                    cachedClassLoader = new CachedClassLoader(libClasspath, classLoader);
                    cacheEntry = new CacheEntry(libClasspath, cachedClassLoader);
                    Cleanup cleanup = new Cleanup(libClasspath, cachedClassLoader, this.finalizerThread.getReferenceQueue(), classLoader, gradleToIsolatedLeakPrevention, antToGradleLeakPrevention);
                    this.finalizerThread.putCleanup(libClasspath, cleanup);
                    this.cacheEntries.put(libClasspath, cacheEntry);
                }
                this.lock.readLock().lock();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Classloader found in cache: %s", libClasspath.getAsURIs()));
        }
        this.lock.readLock().unlock();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Consumer %s uses cached classloader: %s", action.toString(), libClasspath.getAsURIs()));
        }
        this.lock.writeLock().lock();
        this.inUseClassLoaders.add(cachedClassLoader);
        this.lock.writeLock().unlock();
        try {
            action.execute((Object)cachedClassLoader);
        }
        finally {
            this.lock.writeLock().lock();
            this.inUseClassLoaders.remove(cachedClassLoader);
            this.lock.writeLock().unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("End of usage of cached classloader: %s by consumer %s", libClasspath.getAsURIs(), action.toString()));
        }
    }

    private CachedClassLoader maybeGet(CacheEntry cacheEntry) {
        return cacheEntry != null ? (CachedClassLoader)cacheEntry.get() : null;
    }
}

