/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classloading;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.gradle.api.internal.classloading.MemoryLeakPrevention;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyJava7RuntimeMemoryLeakStrategy
extends MemoryLeakPrevention.Strategy {
    private static final Logger LOG = Logging.getLogger(GroovyJava7RuntimeMemoryLeakStrategy.class);
    private static final boolean HAS_CLASS_VALUE;
    private Class<?> classInfoClass;
    private Method removeFromGlobalClassValue;
    private Method globalClassSetIteratorMethod;
    private Object globalClassValue;
    private Object globalClassSetItems;
    private Field clazzField;
    private Class<ClassInfo> gradleClassInfoClass;
    private ClassLoader gradleClassInfoClassLoader;
    private boolean isFaultyGroovy;

    @Override
    public boolean appliesTo(ClassPath classpath) {
        if (!HAS_CLASS_VALUE) {
            return false;
        }
        if (classpath == null) {
            return true;
        }
        for (URI uri : classpath.getAsURIs()) {
            if (!uri.getPath().contains("groovy")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepare(ClassLoader leakingLoader, ClassLoader ... affectedLoaders) throws Exception {
        Class<?> groovySystem = leakingLoader.loadClass("groovy.lang.GroovySystem");
        try {
            Method getVersion = groovySystem.getDeclaredMethod("getVersion", new Class[0]);
            String versionString = (String)getVersion.invoke(null, new Object[0]);
            VersionNumber groovyVersion = VersionNumber.parse(versionString);
            this.isFaultyGroovy = groovyVersion.getMajor() == 2 && groovyVersion.getMinor() == 4;
        }
        catch (NoSuchMethodException ex) {
            this.isFaultyGroovy = false;
        }
        if (!this.isFaultyGroovy) {
            return;
        }
        this.classInfoClass = leakingLoader.loadClass("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassValueField = this.classInfoClass.getDeclaredField("globalClassValue");
        globalClassValueField.setAccessible(true);
        this.globalClassValue = globalClassValueField.get(null);
        this.removeFromGlobalClassValue = globalClassValueField.getType().getDeclaredMethod("remove", Class.class);
        this.removeFromGlobalClassValue.setAccessible(true);
        Field globalClassSetField = this.classInfoClass.getDeclaredField("globalClassSet");
        globalClassSetField.setAccessible(true);
        Object globalClassSet = globalClassSetField.get(null);
        globalClassSetField = globalClassSet.getClass().getDeclaredField("items");
        globalClassSetField.setAccessible(true);
        this.globalClassSetItems = globalClassSetField.get(globalClassSet);
        this.globalClassSetIteratorMethod = this.globalClassSetItems.getClass().getDeclaredMethod("iterator", new Class[0]);
        this.clazzField = this.classInfoClass.getDeclaredField("klazz");
        this.clazzField.setAccessible(true);
        this.gradleClassInfoClass = ClassInfo.class;
        this.gradleClassInfoClassLoader = this.gradleClassInfoClass.getClassLoader();
    }

    @Override
    public void dispose(ClassLoader classLoader, ClassLoader ... affectedLoaders) throws Exception {
        if (!this.isFaultyGroovy) {
            return;
        }
        Iterator<?> it = this.globalClassSetIterator();
        while (it.hasNext()) {
            Class clazz;
            Object classInfo = it.next();
            if (classInfo == null || !this.inHierarchy(clazz = (Class)this.clazzField.get(classInfo), affectedLoaders)) continue;
            this.removeFromGlobalClassValue.invoke(this.globalClassValue, clazz);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(String.format("Removed ClassInfo from %s loaded by %s", clazz.getName(), clazz.getClassLoader()));
        }
    }

    private Iterator<?> globalClassSetIterator() throws IllegalAccessException, InvocationTargetException {
        return (Iterator)this.globalClassSetIteratorMethod.invoke(this.globalClassSetItems, new Object[0]);
    }

    private boolean inHierarchy(Class clazz, ClassLoader ... loaders) {
        if (loaders == null) {
            return false;
        }
        for (ClassLoader loader : loaders) {
            if (!this.inHierarchy(clazz, loader)) continue;
            return true;
        }
        return false;
    }

    private boolean inHierarchy(Class clazz, ClassLoader loader) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (loader == null) {
            return false;
        }
        if (classLoader == null || classLoader == this.gradleClassInfoClassLoader) {
            return this.gradleClassInfoClass != this.classInfoClass;
        }
        if (this.isLoadedInSameHierarchy(loader, classLoader)) {
            return true;
        }
        if (loader instanceof MultiParentClassLoader) {
            List parents = ((MultiParentClassLoader)loader).getParents();
            for (ClassLoader parent : parents) {
                if (!this.inHierarchy(clazz, parent)) continue;
                return true;
            }
        }
        return this.inHierarchy(clazz, loader.getParent());
    }

    private boolean isLoadedInSameHierarchy(ClassLoader loader, ClassLoader ld) {
        while (ld != null && ld != this.gradleClassInfoClassLoader) {
            if (ld == loader) {
                return true;
            }
            if (ld instanceof MultiParentClassLoader) {
                for (ClassLoader classLoader : ((MultiParentClassLoader)ld).getParents()) {
                    if (!this.isLoadedInSameHierarchy(loader, classLoader)) continue;
                    return true;
                }
            }
            ld = ld.getParent();
        }
        return false;
    }

    static {
        boolean cv = true;
        try {
            Class.forName("java.lang.ClassValue");
        }
        catch (ClassNotFoundException e) {
            cv = false;
        }
        HAS_CLASS_VALUE = cv;
    }
}

