/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.authentication;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.specs.Spec;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthentication
implements AuthenticationInternal {
    private final String name;
    private final Set<Class<? extends Credentials>> supportedCredentials;
    private final Class<? extends Authentication> type;
    private Credentials credentials;

    public AbstractAuthentication(String name, Class<? extends Authentication> type) {
        this.name = name;
        this.supportedCredentials = Sets.newHashSet();
        this.type = type;
    }

    public AbstractAuthentication(String name, Class<? extends Authentication> type, Class<? extends Credentials> supportedCredential) {
        this.name = name;
        this.supportedCredentials = Sets.newHashSet((Object[])new Class[]{supportedCredential});
        this.type = type;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Set<Class<? extends Credentials>> getSupportedCredentials() {
        return this.supportedCredentials;
    }

    @Override
    public boolean supports(final Credentials credentials) {
        return CollectionUtils.any(this.getSupportedCredentials(), (Spec)new Spec<Class<? extends Credentials>>(){

            public boolean isSatisfiedBy(Class<? extends Credentials> element) {
                return element.isAssignableFrom(credentials.getClass());
            }
        });
    }

    @Override
    public Class<? extends Authentication> getType() {
        return this.type;
    }

    public String toString() {
        return String.format("'%s'(%s)", this.getName(), this.getType().getSimpleName());
    }
}

