/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.Closeable;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.ReportedException;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.logging.LoggingManagerInternal;

public class DefaultGradleLauncher
extends GradleLauncher {
    private final GradleInternal gradle;
    private final InitScriptHandler initScriptHandler;
    private final SettingsLoader settingsLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final LoggingManagerInternal loggingManager;
    private final BuildListener buildListener;
    private final ModelConfigurationListener modelConfigurationListener;
    private final BuildCompletionListener buildCompletionListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildConfigurationActionExecuter buildConfigurationActionExecuter;
    private final BuildExecuter buildExecuter;
    private final Closeable buildServices;

    public DefaultGradleLauncher(GradleInternal gradle, InitScriptHandler initScriptHandler, SettingsLoader settingsLoader, BuildConfigurer buildConfigurer, ExceptionAnalyser exceptionAnalyser, LoggingManagerInternal loggingManager, BuildListener buildListener, ModelConfigurationListener modelConfigurationListener, BuildCompletionListener buildCompletionListener, BuildOperationExecutor operationExecutor, BuildConfigurationActionExecuter buildConfigurationActionExecuter, BuildExecuter buildExecuter, Closeable buildServices) {
        this.gradle = gradle;
        this.initScriptHandler = initScriptHandler;
        this.settingsLoader = settingsLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.loggingManager = loggingManager;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildOperationExecutor = operationExecutor;
        this.buildConfigurationActionExecuter = buildConfigurationActionExecuter;
        this.buildExecuter = buildExecuter;
        this.buildCompletionListener = buildCompletionListener;
        this.buildServices = buildServices;
    }

    public GradleInternal getGradle() {
        return this.gradle;
    }

    public BuildResult run() {
        return this.doBuild(Stage.Build);
    }

    public BuildResult getBuildAnalysis() {
        return this.doBuild(Stage.Configure);
    }

    private BuildResult doBuild(final Stage upTo) {
        this.loggingManager.start();
        return this.buildOperationExecutor.run("Run build", new Factory<BuildResult>(){

            public BuildResult create() {
                Throwable failure = null;
                try {
                    DefaultGradleLauncher.this.buildListener.buildStarted(DefaultGradleLauncher.this.gradle);
                    DefaultGradleLauncher.this.doBuildStages(upTo);
                }
                catch (Throwable t) {
                    failure = DefaultGradleLauncher.this.exceptionAnalyser.transform(t);
                }
                BuildResult buildResult = new BuildResult(DefaultGradleLauncher.this.gradle, failure);
                DefaultGradleLauncher.this.buildListener.buildFinished(buildResult);
                if (failure != null) {
                    throw new ReportedException(failure);
                }
                return buildResult;
            }
        });
    }

    private void doBuildStages(Stage upTo) {
        this.initScriptHandler.executeScripts(this.gradle);
        this.settingsLoader.findAndLoadSettings(this.gradle);
        this.buildOperationExecutor.run("Configure build", new Runnable(){

            public void run() {
                DefaultGradleLauncher.this.buildConfigurer.configure(DefaultGradleLauncher.this.gradle);
                if (!DefaultGradleLauncher.this.gradle.getStartParameter().isConfigureOnDemand()) {
                    DefaultGradleLauncher.this.buildListener.projectsEvaluated(DefaultGradleLauncher.this.gradle);
                }
                DefaultGradleLauncher.this.modelConfigurationListener.onConfigure(DefaultGradleLauncher.this.gradle);
            }
        });
        if (upTo == Stage.Configure) {
            return;
        }
        this.buildOperationExecutor.run("Calculate task graph", new Runnable(){

            public void run() {
                DefaultGradleLauncher.this.buildConfigurationActionExecuter.select(DefaultGradleLauncher.this.gradle);
                if (DefaultGradleLauncher.this.gradle.getStartParameter().isConfigureOnDemand()) {
                    DefaultGradleLauncher.this.buildListener.projectsEvaluated(DefaultGradleLauncher.this.gradle);
                }
            }
        });
        this.buildOperationExecutor.run("Run tasks", new Runnable(){

            public void run() {
                DefaultGradleLauncher.this.buildExecuter.execute(DefaultGradleLauncher.this.gradle);
            }
        });
        assert (upTo == Stage.Build);
    }

    public void addListener(Object listener) {
        this.gradle.addListener(listener);
    }

    public void addStandardOutputListener(StandardOutputListener listener) {
        this.loggingManager.addStandardOutputListener(listener);
    }

    public void addStandardErrorListener(StandardOutputListener listener) {
        this.loggingManager.addStandardErrorListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.loggingManager.stop();
            CompositeStoppable.stoppable((Object[])new Object[]{this.buildServices}).stop();
        }
        finally {
            this.buildCompletionListener.completed();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        Configure,
        Build;

    }
}

