/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.DefaultScriptTarget;
import org.gradle.configuration.InitScriptTarget;
import org.gradle.configuration.ProjectScriptTarget;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.ScriptTarget;
import org.gradle.configuration.SettingScriptTarget;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.BuildScriptData;
import org.gradle.groovy.scripts.internal.BuildScriptDataSerializer;
import org.gradle.groovy.scripts.internal.BuildScriptTransformer;
import org.gradle.groovy.scripts.internal.FactoryBackedCompileOperation;
import org.gradle.groovy.scripts.internal.InitialPassStatementTransformer;
import org.gradle.groovy.scripts.internal.SubsetScriptTransformer;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.model.dsl.internal.transform.ClosureCreationInterceptingVerifier;
import org.gradle.model.dsl.internal.transform.ModelBlockTransformer;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.plugin.use.internal.PluginRequests;
import org.gradle.plugin.use.internal.PluginRequestsSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final Instantiator instantiator;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final PluginRequestApplicator pluginRequestApplicator;
    private final FileLookup fileLookup;
    private final DocumentationRegistry documentationRegistry;
    private final ModelRuleSourceDetector modelRuleSourceDetector;
    private final BuildScriptDataSerializer buildScriptDataSerializer = new BuildScriptDataSerializer();
    private final PluginRequestsSerializer pluginRequestsSerializer = new PluginRequestsSerializer();

    public DefaultScriptPluginFactory(ScriptCompilerFactory scriptCompilerFactory, Factory<LoggingManagerInternal> loggingManagerFactory, Instantiator instantiator, ScriptHandlerFactory scriptHandlerFactory, PluginRequestApplicator pluginRequestApplicator, FileLookup fileLookup, DocumentationRegistry documentationRegistry, ModelRuleSourceDetector modelRuleSourceDetector) {
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.loggingManagerFactory = loggingManagerFactory;
        this.instantiator = instantiator;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.pluginRequestApplicator = pluginRequestApplicator;
        this.fileLookup = fileLookup;
        this.documentationRegistry = documentationRegistry;
        this.modelRuleSourceDetector = modelRuleSourceDetector;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
        return new ScriptPluginImpl(scriptSource, (ScriptHandlerInternal)scriptHandler, targetScope, baseScope, topLevelScript);
    }

    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private final ClassLoaderScope targetScope;
        private final ClassLoaderScope baseScope;
        private final ScriptHandlerInternal scriptHandler;
        private final boolean topLevelScript;

        public ScriptPluginImpl(ScriptSource scriptSource, ScriptHandlerInternal scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
            this.scriptSource = scriptSource;
            this.targetScope = targetScope;
            this.baseScope = baseScope;
            this.scriptHandler = scriptHandler;
            this.topLevelScript = topLevelScript;
        }

        public ScriptSource getSource() {
            return this.scriptSource;
        }

        public void apply(final Object target) {
            final DefaultServiceRegistry services = new DefaultServiceRegistry();
            services.add(ScriptPluginFactory.class, (Object)DefaultScriptPluginFactory.this);
            services.add(ScriptHandlerFactory.class, (Object)DefaultScriptPluginFactory.this.scriptHandlerFactory);
            services.add(ClassLoaderScope.class, (Object)this.targetScope);
            services.add(LoggingManagerInternal.class, DefaultScriptPluginFactory.this.loggingManagerFactory.create());
            services.add(Instantiator.class, (Object)DefaultScriptPluginFactory.this.instantiator);
            services.add(ScriptHandler.class, (Object)this.scriptHandler);
            services.add(FileLookup.class, (Object)DefaultScriptPluginFactory.this.fileLookup);
            services.add(ModelRuleSourceDetector.class, (Object)DefaultScriptPluginFactory.this.modelRuleSourceDetector);
            ScriptTarget scriptTarget = this.wrap(target);
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(this.scriptSource);
            Class<? extends BasicScript> scriptType = scriptTarget.getScriptClass();
            boolean supportsPluginsBlock = scriptTarget.getSupportsPluginsBlock();
            String onPluginBlockError = supportsPluginsBlock ? null : "Only Project build scripts can contain plugins {} blocks";
            String classpathClosureName = scriptTarget.getClasspathBlockName();
            InitialPassStatementTransformer initialPassStatementTransformer = new InitialPassStatementTransformer(classpathClosureName, onPluginBlockError, this.scriptSource, DefaultScriptPluginFactory.this.documentationRegistry);
            SubsetScriptTransformer initialTransformer = new SubsetScriptTransformer(initialPassStatementTransformer);
            FactoryBackedCompileOperation<PluginRequests> initialOperation = new FactoryBackedCompileOperation<PluginRequests>("cp_" + scriptTarget.getId(), (Transformer)initialTransformer, initialPassStatementTransformer, DefaultScriptPluginFactory.this.pluginRequestsSerializer);
            ScriptRunner<? extends BasicScript, PluginRequests> initialRunner = compiler.compile(scriptType, initialOperation, this.baseScope.getExportClassLoader(), (Action<? super ClassNode>)Actions.doNothing());
            initialRunner.run(target, (ServiceRegistry)services);
            PluginRequests pluginRequests = initialRunner.getData();
            PluginManagerInternal pluginManager = scriptTarget.getPluginManager();
            DefaultScriptPluginFactory.this.pluginRequestApplicator.applyPlugins(pluginRequests, this.scriptHandler, pluginManager, this.targetScope);
            BuildScriptTransformer buildScriptTransformer = new BuildScriptTransformer(classpathClosureName, this.scriptSource);
            String operationId = scriptTarget.getId();
            if (ModelBlockTransformer.isEnabled()) {
                operationId = "m_".concat(operationId);
            }
            FactoryBackedCompileOperation<BuildScriptData> operation = new FactoryBackedCompileOperation<BuildScriptData>(operationId, buildScriptTransformer, buildScriptTransformer, DefaultScriptPluginFactory.this.buildScriptDataSerializer);
            final ScriptRunner<? extends BasicScript, BuildScriptData> runner = compiler.compile(scriptType, operation, this.targetScope.getLocalClassLoader(), (Action<? super ClassNode>)ClosureCreationInterceptingVerifier.INSTANCE);
            if (scriptTarget.getSupportsMethodInheritance() && runner.getHasMethods()) {
                scriptTarget.attachScript(runner.getScript());
            }
            if (!runner.getRunDoesSomething()) {
                return;
            }
            Runnable buildScriptRunner = new Runnable(){

                public void run() {
                    runner.run(target, (ServiceRegistry)services);
                }
            };
            boolean hasImperativeStatements = runner.getData().getHasImperativeStatements();
            scriptTarget.addConfiguration(buildScriptRunner, !hasImperativeStatements);
        }

        private ScriptTarget wrap(Object target) {
            if (target instanceof ProjectInternal && this.topLevelScript) {
                return new ProjectScriptTarget((ProjectInternal)target);
            }
            if (target instanceof GradleInternal && this.topLevelScript) {
                return new InitScriptTarget((GradleInternal)target);
            }
            if (target instanceof SettingsInternal && this.topLevelScript) {
                return new SettingScriptTarget((SettingsInternal)target);
            }
            return new DefaultScriptTarget(target);
        }
    }
}

