/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.collections.LazilyInitializedFileTree;
import org.gradle.api.internal.resources.FileCollectionBackedTextResource;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;

public class FileCollectionBackedArchiveTextResource
extends FileCollectionBackedTextResource {
    public FileCollectionBackedArchiveTextResource(final FileOperations fileOperations, TemporaryFileProvider tempFileProvider, final FileCollection fileCollection, final String path, Charset charset) {
        super(tempFileProvider, new LazilyInitializedFileTree(){

            public FileTreeInternal createDelegate() {
                File archiveFile = fileCollection.getSingleFile();
                String fileExtension = Files.getFileExtension((String)archiveFile.getName());
                FileTree archiveContents = fileExtension.equals("jar") || fileExtension.equals("zip") ? fileOperations.zipTree(archiveFile) : fileOperations.tarTree(archiveFile);
                PatternSet patternSet = new PatternSet();
                patternSet.include(path);
                return (FileTreeInternal)Cast.cast(FileTreeInternal.class, (Object)archiveContents.matching(patternSet));
            }

            public TaskDependency getBuildDependencies() {
                return fileCollection.getBuildDependencies();
            }
        }, charset);
    }
}

