/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildConfigurationActionExecuter
implements BuildConfigurationActionExecuter {
    private final List<BuildConfigurationAction> configurationActions;
    private final List<Transformer<List<BuildConfigurationAction>, List<BuildConfigurationAction>>> configurationActionsTransformations;

    public DefaultBuildConfigurationActionExecuter(Iterable<? extends BuildConfigurationAction> configurationActions) {
        this.configurationActions = Lists.newArrayList(configurationActions);
        this.configurationActionsTransformations = Lists.newArrayList();
    }

    @Override
    public void registerBuildConfigurationTransformer(Transformer<List<BuildConfigurationAction>, List<BuildConfigurationAction>> transformer) {
        this.configurationActionsTransformations.add(transformer);
    }

    @Override
    public void select(GradleInternal gradle) {
        List processingBuildActions = this.configurationActions;
        for (Transformer<List<BuildConfigurationAction>, List<BuildConfigurationAction>> customizationAction : this.configurationActionsTransformations) {
            processingBuildActions = (List)customizationAction.transform(processingBuildActions);
        }
        this.configure(processingBuildActions, gradle, 0);
    }

    private void configure(final List<BuildConfigurationAction> processingConfigurationActions, final GradleInternal gradle, final int index) {
        if (index >= processingConfigurationActions.size()) {
            return;
        }
        processingConfigurationActions.get(index).configure(new BuildExecutionContext(){

            public GradleInternal getGradle() {
                return gradle;
            }

            public void proceed() {
                DefaultBuildConfigurationActionExecuter.this.configure(processingConfigurationActions, gradle, index + 1);
            }
        });
    }
}

