/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.collection.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.CollectionBuilderModelView;
import org.gradle.model.internal.core.DefaultCollectionBuilder;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomainObjectContainerModelProjection<C extends PolymorphicDomainObjectContainerInternal<M>, M>
implements ModelProjection {
    protected final Class<M> baseItemType;
    private final ModelReference<NamedEntityInstantiator<M>> instantiatorModelReference;
    private final ModelType<M> baseItemModelType;
    private final ModelReference<? extends Collection<? super M>> storeReference;

    public DomainObjectContainerModelProjection(ModelType<M> baseItemType, ModelReference<NamedEntityInstantiator<M>> instantiatorModelReference, ModelReference<? extends Collection<? super M>> storeReference) {
        this.baseItemModelType = baseItemType;
        this.storeReference = storeReference;
        this.baseItemType = baseItemType.getConcreteClass();
        this.instantiatorModelReference = instantiatorModelReference;
    }

    public <T> ModelView<? extends T> asWritable(ModelType<T> targetType, MutableModelNode node, ModelRuleDescriptor ruleDescriptor, List<ModelView<?>> inputs) {
        Class<M> itemType = this.itemType(targetType);
        if (itemType != null) {
            return this.toView(ruleDescriptor, node, itemType);
        }
        return null;
    }

    protected <T, S extends M> ModelView<? extends T> toView(ModelRuleDescriptor sourceDescriptor, MutableModelNode node, Class<S> itemClass) {
        CollectionBuilderModelView view;
        ModelType itemType = ModelType.of(itemClass);
        DefaultCollectionBuilder builder = new DefaultCollectionBuilder(this.baseItemModelType, sourceDescriptor, node, DefaultCollectionBuilder.createAndStoreVia(this.instantiatorModelReference, this.storeReference));
        CollectionBuilder subBuilder = builder.withType(itemClass);
        CollectionBuilderModelView cast = view = new CollectionBuilderModelView(node.getPath(), DefaultCollectionBuilder.typeOf((ModelType)itemType), subBuilder, sourceDescriptor);
        return cast;
    }

    public static String getBuilderTypeDescriptionForCreatableTypes(Collection<? extends Class<?>> createableTypes) {
        StringBuilder sb = new StringBuilder(CollectionBuilder.class.getName());
        if (createableTypes.size() == 1) {
            String onlyType = ((Class)Iterables.getFirst(createableTypes, null)).getName();
            sb.append("<").append(onlyType).append(">");
        } else {
            sb.append("<T>; where T is one of [");
            Joiner.on((String)", ").appendTo(sb, (Iterable)CollectionUtils.sort((Iterable)Iterables.transform(createableTypes, (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    return input.getName();
                }
            })));
            sb.append("]");
        }
        return sb.toString();
    }

    public <T> boolean canBeViewedAsWritable(ModelType<T> targetType) {
        return this.itemType(targetType) != null;
    }

    protected Class<? extends M> itemType(ModelType<?> targetType) {
        Class targetClass = targetType.getRawClass();
        if (targetClass.equals(CollectionBuilder.class)) {
            Class targetItemClass = ((ModelType)targetType.getTypeVariables().get(0)).getRawClass();
            if (targetItemClass.isAssignableFrom(this.baseItemType)) {
                return this.baseItemType;
            }
            if (this.baseItemType.isAssignableFrom(targetItemClass)) {
                return targetItemClass.asSubclass(this.baseItemType);
            }
            return null;
        }
        if (targetClass.isAssignableFrom(CollectionBuilder.class)) {
            return this.baseItemType;
        }
        return null;
    }

    public <T> boolean canBeViewedAsReadOnly(ModelType<T> type) {
        return this.canBeViewedAsWritable(type);
    }

    public <T> ModelView<? extends T> asReadOnly(ModelType<T> type, MutableModelNode modelNode, @Nullable ModelRuleDescriptor ruleDescriptor) {
        return this.asWritable(type, modelNode, ruleDescriptor, null);
    }

    public Iterable<String> getReadableTypeDescriptions() {
        return this.getWritableTypeDescriptions();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainObjectContainerModelProjection that = (DomainObjectContainerModelProjection)o;
        return this.baseItemType.equals(that.baseItemType) && this.instantiatorModelReference.equals(that.instantiatorModelReference);
    }

    public int hashCode() {
        int result = this.baseItemType.hashCode();
        result = 31 * result + this.instantiatorModelReference.hashCode();
        return result;
    }
}

