/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.MessagingClient;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.MessagingServices;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.process.internal.child.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionExecutionWorker
implements Action<WorkerContext>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionExecutionWorker.class);
    private final Action<? super WorkerProcessContext> action;
    private final Object workerId;
    private final String displayName;
    private final Address serverAddress;

    public ActionExecutionWorker(Action<? super WorkerProcessContext> action, Object workerId, String displayName, Address serverAddress) {
        this.action = action;
        this.workerId = workerId;
        this.displayName = displayName;
        this.serverAddress = serverAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final WorkerContext workerContext) {
        MessagingServices messagingServices = this.createClient();
        try {
            MessagingClient client = (MessagingClient)messagingServices.get(MessagingClient.class);
            final ObjectConnection clientConnection = client.getConnection(this.serverAddress);
            try {
                LOGGER.debug("Starting {}.", (Object)this.displayName);
                WorkerProcessContext context = new WorkerProcessContext(){

                    public ObjectConnection getServerConnection() {
                        return clientConnection;
                    }

                    public ClassLoader getApplicationClassLoader() {
                        return workerContext.getApplicationClassLoader();
                    }

                    public Object getWorkerId() {
                        return ActionExecutionWorker.this.workerId;
                    }

                    public String getDisplayName() {
                        return ActionExecutionWorker.this.displayName;
                    }
                };
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
                try {
                    this.action.execute((Object)context);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
                LOGGER.debug("Completed {}.", (Object)this.displayName);
            }
            finally {
                clientConnection.stop();
            }
        }
        finally {
            LOGGER.debug("Stopping client connection.");
            messagingServices.stop();
        }
    }

    MessagingServices createClient() {
        return new MessagingServices(this.getClass().getClassLoader());
    }
}

