/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.collection.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.Transformer;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.CollectionBuilderModelView;
import org.gradle.model.internal.core.DefaultCollectionBuilder;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.ProjectionBackedModelAdapter;
import org.gradle.model.internal.core.ProjectionBackedModelPromise;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicDomainObjectContainerModelProjection<C extends PolymorphicDomainObjectContainerInternal<M>, M>
implements ModelProjection {
    private final Instantiator instantiator;
    private final C container;
    private final Class<M> itemType;

    public PolymorphicDomainObjectContainerModelProjection(Instantiator instantiator, C container, Class<M> itemType) {
        this.instantiator = instantiator;
        this.container = container;
        this.itemType = itemType;
    }

    public <T> boolean canBeViewedAsWritable(ModelType<T> targetType) {
        if (targetType.getRawClass().equals(CollectionBuilder.class)) {
            ModelType targetItemType = (ModelType)targetType.getTypeVariables().get(0);
            return targetItemType.getRawClass().isAssignableFrom(this.itemType) || this.itemType.isAssignableFrom(targetItemType.getRawClass());
        }
        return false;
    }

    public <T> boolean canBeViewedAsReadOnly(ModelType<T> type) {
        return false;
    }

    public <T> ModelView<? extends T> asWritable(ModelType<T> targetType, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelNode node) {
        if (this.canBeViewedAsWritable(targetType)) {
            ModelType targetItemType = (ModelType)targetType.getTypeVariables().get(0);
            if (targetItemType.getRawClass().isAssignableFrom(this.itemType)) {
                return this.toView(sourceDescriptor, node, this.itemType, this.container);
            }
            Class<M> subType = targetItemType.getRawClass().asSubclass(this.itemType);
            return this.toView(sourceDescriptor, node, subType, this.container);
        }
        return null;
    }

    private <T, S extends M> ModelView<? extends T> toView(ModelRuleDescriptor sourceDescriptor, ModelNode node, Class<S> itemType, C container) {
        CollectionBuilderModelView view;
        DefaultCollectionBuilder builder = new DefaultCollectionBuilder(new EntityInstantiator<S>(itemType, container), sourceDescriptor, node);
        ModelType viewType = new ModelType.Builder<CollectionBuilder<S>>(){}.where(new ModelType.Parameter<S>(){}, ModelType.of(itemType)).build();
        CollectionBuilderModelView cast = view = new CollectionBuilderModelView(this.instantiator, viewType, (CollectionBuilder)builder, sourceDescriptor);
        return cast;
    }

    public <T> ModelView<? extends T> asReadOnly(ModelType<T> type, ModelNode modelNode) {
        return null;
    }

    public Iterable<String> getWritableTypeDescriptions() {
        return Collections.singleton(PolymorphicDomainObjectContainerModelProjection.getBuilderTypeDescriptionForCreatableTypes(this.container.getCreateableTypes()));
    }

    public Iterable<String> getReadableTypeDescriptions() {
        return Collections.emptySet();
    }

    public static String getBuilderTypeDescriptionForCreatableTypes(Collection<? extends Class<?>> createableTypes) {
        StringBuilder sb = new StringBuilder(CollectionBuilder.class.getName());
        if (createableTypes.size() == 1) {
            String onlyType = ((Class)Iterables.getFirst(createableTypes, null)).getName();
            sb.append("<").append(onlyType).append(">");
        } else {
            sb.append("<T>; where T is one of [");
            Joiner.on((String)", ").appendTo(sb, (Iterable)CollectionUtils.sort((Iterable)Iterables.transform(createableTypes, (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    return input.getName();
                }
            })));
            sb.append("]");
        }
        return sb.toString();
    }

    public static <I, C extends PolymorphicDomainObjectContainerInternal<I>, P> void bridgeNamedDomainObjectCollection(final ModelRegistry modelRegistry, Instantiator instantiator, final ModelType<C> containerType, ModelType<P> publicType, ModelType<I> itemType, final ModelPath modelPath, final C container, final Namer<I> namer, String descriptor, final Transformer<String, String> itemDescriptorGenerator) {
        modelRegistry.create(ModelCreators.of((ModelReference)ModelReference.of((ModelPath)modelPath, containerType), (Transformer)new Transformer<Action<? super ModelNode>, Inputs>(){

            public Action<? super ModelNode> transform(Inputs inputs) {
                return new Action<ModelNode>(){

                    public void execute(final ModelNode modelNode) {
                        modelNode.setPrivateData(containerType, (Object)container);
                        container.all(new Action<I>(){

                            public void execute(I item) {
                                String name = namer.determineName(item);
                                if (!modelNode.getLinks().containsKey(name)) {
                                    UnmanagedModelProjection projection = new UnmanagedModelProjection(ModelType.typeOf(item), true, true);
                                    Set<UnmanagedModelProjection> projections = Collections.singleton(projection);
                                    modelNode.addLink(name, (ModelRuleDescriptor)new SimpleModelRuleDescriptor((String)itemDescriptorGenerator.transform((Object)name)), (ModelPromise)new ProjectionBackedModelPromise(projections), (ModelAdapter)new ProjectionBackedModelAdapter(projections)).setPrivateData(ModelType.typeOf(item), item);
                                }
                            }
                        });
                    }
                };
            }
        }).simpleDescriptor(descriptor).withProjection((ModelProjection)new UnmanagedModelProjection(publicType, true, true)).withProjection(new PolymorphicDomainObjectContainerModelProjection(instantiator, container, itemType.getConcreteClass())).build());
        container.whenObjectRemoved(new Action<I>(){

            public void execute(I item) {
                ModelPath path = modelPath.child(namer.determineName(item));
                modelRegistry.remove(path);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntityInstantiator<I>
    implements NamedEntityInstantiator<I> {
        private final Class<I> defaultType;
        private final ModelType<I> itemType;
        private final PolymorphicDomainObjectContainer<? super I> container;

        EntityInstantiator(Class<I> defaultType, PolymorphicDomainObjectContainer<? super I> container) {
            this.defaultType = defaultType;
            this.itemType = ModelType.of(defaultType);
            this.container = container;
        }

        public ModelType<I> getType() {
            return this.itemType;
        }

        public I create(String name) {
            return this.container.create(name, this.defaultType);
        }

        public <S extends I> S create(String name, Class<S> type) {
            return this.container.create(name, type);
        }
    }
}

