/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.ClassGeneratorBackedInstantiator;
import org.gradle.api.internal.DependencyInjectingInstantiator;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.artifacts.DependencyManagementServices;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.ProjectBackedModule;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.component.DefaultSoftwareComponentContainer;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.initialization.DefaultScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultPluginManager;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.plugins.RulesCapablePluginApplicator;
import org.gradle.api.internal.project.DefaultAntBuilderFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskContainerFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.configuration.project.DefaultProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.PluginServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.service.scopes.TaskScopeServices;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.model.internal.inspect.MethodRuleDefinitionHandler;
import org.gradle.model.internal.inspect.MethodRuleDefinitionHandlers;
import org.gradle.model.internal.inspect.ModelRuleInspector;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.DefaultModelRegistry;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.internal.DefaultToolingModelBuilderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectScopeServices
extends DefaultServiceRegistry {
    private final ProjectInternal project;

    public ProjectScopeServices(final ServiceRegistry parent, final ProjectInternal project) {
        super(new ServiceRegistry[]{parent});
        this.project = project;
        this.register((Action)new Action<ServiceRegistration>(){

            public void execute(ServiceRegistration registration) {
                registration.add(DomainObjectContext.class, (Object)project);
                ((DependencyManagementServices)parent.get(DependencyManagementServices.class)).addDslServices(registration);
                for (PluginServiceRegistry pluginServiceRegistry : parent.getAll(PluginServiceRegistry.class)) {
                    pluginServiceRegistry.registerProjectServices(registration);
                }
            }
        });
    }

    protected PluginRegistry createPluginRegistry(PluginRegistry parentRegistry) {
        return parentRegistry.createChild(this.project.getClassLoaderScope().createChild().lock());
    }

    protected FileResolver createFileResolver() {
        return new BaseDirFileResolver((FileSystem)this.get(FileSystem.class), this.project.getProjectDir());
    }

    protected LoggingManagerInternal createLoggingManager() {
        return (LoggingManagerInternal)this.getFactory(LoggingManagerInternal.class).create();
    }

    protected ProjectConfigurationActionContainer createProjectConfigurationActionContainer() {
        return new DefaultProjectConfigurationActionContainer();
    }

    protected DefaultFileOperations createFileOperations() {
        return new DefaultFileOperations((FileResolver)this.get(FileResolver.class), this.project.getTasks(), (TemporaryFileProvider)this.get(TemporaryFileProvider.class), (Instantiator)this.get(Instantiator.class), (FileLookup)this.get(FileLookup.class));
    }

    protected TemporaryFileProvider createTemporaryFileProvider() {
        return new DefaultTemporaryFileProvider(new Factory<File>(){

            public File create() {
                return new File(ProjectScopeServices.this.project.getBuildDir(), "tmp");
            }
        });
    }

    protected Factory<AntBuilder> createAntBuilderFactory() {
        return new DefaultAntBuilderFactory((BuildListener)new AntLoggingAdapter(), this.project);
    }

    protected ToolingModelBuilderRegistry createToolingModelRegistry() {
        return new DefaultToolingModelBuilderRegistry();
    }

    protected PluginManagerInternal createPluginManager(Instantiator instantiator) {
        List handlers = this.getAll(MethodRuleDefinitionHandler.class);
        List coreHandlers = MethodRuleDefinitionHandlers.coreHandlers((Instantiator)instantiator, (ModelSchemaStore)((ModelSchemaStore)this.get(ModelSchemaStore.class)));
        ModelRuleInspector inspector = new ModelRuleInspector(Iterables.concat((Iterable)coreHandlers, (Iterable)handlers));
        RulesCapablePluginApplicator<ProjectInternal> applicator = new RulesCapablePluginApplicator<ProjectInternal>(this.project, inspector, (ModelRuleSourceDetector)this.get(ModelRuleSourceDetector.class));
        return (PluginManagerInternal)instantiator.newInstance(DefaultPluginManager.class, new Object[]{this.get(PluginRegistry.class), new DependencyInjectingInstantiator((ServiceRegistry)this), applicator});
    }

    protected ITaskFactory createTaskFactory(ITaskFactory parentFactory) {
        return parentFactory.createChild(this.project, new ClassGeneratorBackedInstantiator((ClassGenerator)this.get(ClassGenerator.class), new DependencyInjectingInstantiator((ServiceRegistry)this)));
    }

    protected Factory<TaskContainerInternal> createTaskContainerInternal() {
        return new DefaultTaskContainerFactory((Instantiator)this.get(Instantiator.class), (ITaskFactory)this.get(ITaskFactory.class), this.project, (ProjectAccessListener)this.get(ProjectAccessListener.class));
    }

    protected SoftwareComponentContainer createSoftwareComponentContainer() {
        Instantiator instantiator = (Instantiator)this.get(Instantiator.class);
        return (SoftwareComponentContainer)instantiator.newInstance(DefaultSoftwareComponentContainer.class, new Object[]{instantiator});
    }

    protected ProjectFinder createProjectFinder() {
        return new ProjectFinder(){

            public ProjectInternal getProject(String path) {
                return ProjectScopeServices.this.project.project(path);
            }
        };
    }

    protected ModelRegistry createModelRegistry() {
        return new DefaultModelRegistry();
    }

    protected ScriptHandler createScriptHandler() {
        DefaultScriptHandlerFactory factory = new DefaultScriptHandlerFactory((DependencyManagementServices)this.get(DependencyManagementServices.class), (FileResolver)this.get(FileResolver.class), (DependencyMetaDataProvider)this.get(DependencyMetaDataProvider.class));
        return factory.create(this.project.getBuildScriptSource(), this.project.getClassLoaderScope(), this.project);
    }

    protected DependencyMetaDataProvider createDependencyMetaDataProvider() {
        return new DependencyMetaDataProvider(){

            public ModuleInternal getModule() {
                return new ProjectBackedModule(ProjectScopeServices.this.project);
            }
        };
    }

    protected ServiceRegistryFactory createServiceRegistryFactory(final ServiceRegistry services) {
        return new ServiceRegistryFactory(){

            public ServiceRegistry createFor(Object domainObject) {
                if (domainObject instanceof TaskInternal) {
                    return new TaskScopeServices(services, ProjectScopeServices.this.project, (TaskInternal)domainObject);
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ComponentRegistry createComponentRegistry() {
        return new ComponentRegistry();
    }
}

