/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.File;
import java.lang.reflect.Field;
import java.security.CodeSource;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.initialization.ClassLoaderIds;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.EmptyScriptGenerator;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.util.Clock;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptCompilationHandler
implements ScriptCompilationHandler {
    private Logger logger = LoggerFactory.getLogger(DefaultScriptCompilationHandler.class);
    private static final String EMPTY_SCRIPT_MARKER_FILE_NAME = "emptyScript.txt";
    private final EmptyScriptGenerator emptyScriptGenerator;
    private final ClassLoaderCache classLoaderCache;

    public DefaultScriptCompilationHandler(EmptyScriptGenerator emptyScriptGenerator, ClassLoaderCache classLoaderCache) {
        this.emptyScriptGenerator = emptyScriptGenerator;
        this.classLoaderCache = classLoaderCache;
    }

    @Override
    public void compileToDir(ScriptSource source, ClassLoader classLoader, File classesDir, Transformer transformer, Class<? extends Script> scriptBaseClass, Action<? super ClassNode> verifier) {
        Clock clock = new Clock();
        GFileUtils.deleteDirectory(classesDir);
        GFileUtils.mkdirs(classesDir);
        CompilerConfiguration configuration = this.createBaseCompilerConfiguration(scriptBaseClass);
        configuration.setTargetDirectory(classesDir);
        try {
            this.compileScript(source, classLoader, configuration, classesDir, transformer, verifier);
        }
        catch (GradleException e) {
            GFileUtils.deleteDirectory(classesDir);
            throw e;
        }
        this.logger.debug("Timing: Writing script to cache at {} took: {}", (Object)classesDir.getAbsolutePath(), (Object)clock.getTime());
    }

    private void compileScript(final ScriptSource source, ClassLoader classLoader, CompilerConfiguration configuration, File classesDir, final Transformer transformer, final Action<? super ClassNode> customVerifier) {
        this.logger.info("Compiling {} using {}.", (Object)source.getDisplayName(), (Object)(transformer != null ? transformer.getClass().getSimpleName() : "no transformer"));
        final EmptyScriptDetector emptyScriptDetector = new EmptyScriptDetector();
        final PackageStatementDetector packageDetector = new PackageStatementDetector();
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader, configuration, false){

            protected CompilationUnit createCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource) {
                CustomCompilationUnit compilationUnit = new CustomCompilationUnit(compilerConfiguration, codeSource, (Action<? super ClassNode>)customVerifier, source, this);
                if (transformer != null) {
                    transformer.register((CompilationUnit)compilationUnit);
                }
                compilationUnit.addPhaseOperation(packageDetector, 5);
                compilationUnit.addPhaseOperation(emptyScriptDetector, 5);
                return compilationUnit;
            }
        };
        String scriptText = source.getResource().getText();
        String scriptName = source.getClassName();
        GroovyCodeSource codeSource = new GroovyCodeSource(scriptText == null ? "" : scriptText, scriptName, "/groovy/script");
        try {
            groovyClassLoader.parseClass(codeSource, false);
        }
        catch (MultipleCompilationErrorsException e) {
            this.wrapCompilationFailure(source, e);
        }
        catch (CompilationFailedException e) {
            throw new GradleException(String.format("Could not compile %s.", source.getDisplayName()), (Throwable)e);
        }
        if (packageDetector.hasPackageStatement) {
            throw new UnsupportedOperationException(String.format("%s should not contain a package statement.", StringUtils.capitalize((String)source.getDisplayName())));
        }
        if (emptyScriptDetector.isEmptyScript()) {
            GFileUtils.touch(new File(classesDir, EMPTY_SCRIPT_MARKER_FILE_NAME));
        }
    }

    private void wrapCompilationFailure(ScriptSource source, MultipleCompilationErrorsException e) {
        for (Object message : e.getErrorCollector().getErrors()) {
            if (!(message instanceof SyntaxErrorMessage)) continue;
            try {
                SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)message;
                Field sourceField = SyntaxErrorMessage.class.getDeclaredField("source");
                sourceField.setAccessible(true);
                SourceUnit sourceUnit = (SourceUnit)sourceField.get(syntaxErrorMessage);
                Field nameField = SourceUnit.class.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(sourceUnit, source.getDisplayName());
            }
            catch (Exception failure) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
        }
        SyntaxException syntaxError = e.getErrorCollector().getSyntaxError(0);
        Integer lineNumber = syntaxError == null ? null : Integer.valueOf(syntaxError.getLine());
        throw new ScriptCompilationException(String.format("Could not compile %s.", source.getDisplayName()), e, source, lineNumber);
    }

    private CompilerConfiguration createBaseCompilerConfiguration(Class<? extends Script> scriptBaseClass) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setScriptBaseClass(scriptBaseClass.getName());
        return configuration;
    }

    @Override
    public <T extends Script> Class<? extends T> loadFromDir(ScriptSource source, ClassLoader classLoader, File scriptCacheDir, Class<T> scriptBaseClass) {
        if (new File(scriptCacheDir, EMPTY_SCRIPT_MARKER_FILE_NAME).isFile()) {
            return this.emptyScriptGenerator.generate(scriptBaseClass);
        }
        try {
            ClassLoader loader = this.classLoaderCache.get(ClassLoaderIds.buildScript(source.getFileName()), (ClassPath)new DefaultClassPath(new File[]{scriptCacheDir}), classLoader, null);
            return loader.loadClass(source.getClassName()).asSubclass(scriptBaseClass);
        }
        catch (Exception e) {
            File expectedClassFile = new File(scriptCacheDir, source.getClassName() + ".class");
            if (!expectedClassFile.exists()) {
                throw new GradleException(String.format("Could not load compiled classes for %s from cache. Expected class file %s does not exist.", source.getDisplayName(), expectedClassFile.getAbsolutePath()), (Throwable)e);
            }
            throw new GradleException(String.format("Could not load compiled classes for %s from cache.", source.getDisplayName()), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomCompilationUnit
    extends CompilationUnit {
        private final ScriptSource source;

        public CustomCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource, final Action<? super ClassNode> customVerifier, ScriptSource source, GroovyClassLoader groovyClassLoader) {
            super(compilerConfiguration, codeSource, groovyClassLoader);
            this.source = source;
            this.verifier = new Verifier(){

                public void visitClass(ClassNode node) {
                    customVerifier.execute((Object)node);
                    super.visitClass(node);
                }
            };
        }

        protected ClassVisitor createClassVisitor() {
            return new ClassWriter(1){

                public byte[] toByteArray() {
                    this.visitSource(CustomCompilationUnit.this.source.getFileName(), null);
                    return super.toByteArray();
                }
            };
        }
    }

    private static class EmptyScriptDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean emptyScript;

        private EmptyScriptDetector() {
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            this.emptyScript = this.isEmpty(source);
        }

        private boolean isEmpty(SourceUnit source) {
            ConstantExpression constantExpression;
            ReturnStatement returnStatement;
            if (!source.getAST().getMethods().isEmpty()) {
                return false;
            }
            List statements = source.getAST().getStatementBlock().getStatements();
            if (statements.size() > 1) {
                return false;
            }
            if (statements.isEmpty()) {
                return true;
            }
            Statement statement = (Statement)statements.get(0);
            return statement instanceof ReturnStatement && (returnStatement = (ReturnStatement)statement).getExpression() instanceof ConstantExpression && (constantExpression = (ConstantExpression)returnStatement.getExpression()).getValue() == null;
        }

        public boolean isEmptyScript() {
            return this.emptyScript;
        }
    }

    private static class PackageStatementDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean hasPackageStatement;

        private PackageStatementDetector() {
        }

        public void call(SourceUnit source) throws CompilationFailedException {
            this.hasPackageStatement = source.getAST().getPackageName() != null;
        }
    }
}

