/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Nullable;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.taskgraph.TaskDependencyGraph;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.Tuple;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskExecutionPlan
implements TaskExecutionPlan {
    public static final String INTRA_PROJECT_TOGGLE = "org.gradle.parallel.intra";
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskExecutionPlan.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Set<TaskInfo> tasksInUnknownState = new LinkedHashSet<TaskInfo>();
    private final Set<TaskInfo> entryTasks = new LinkedHashSet<TaskInfo>();
    private final TaskDependencyGraph graph = new TaskDependencyGraph();
    private final LinkedHashMap<Task, TaskInfo> executionPlan = new LinkedHashMap();
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private Spec<? super Task> filter = Specs.satisfyAll();
    private TaskFailureHandler failureHandler = new RethrowingFailureHandler();
    private final BuildCancellationToken cancellationToken;
    private final Multiset<String> projectsWithRunningTasks = HashMultiset.create();
    private final Multiset<String> projectsWithRunningNonParallelizableTasks = HashMultiset.create();
    private final Set<TaskInternal> runningTasks = Sets.newIdentityHashSet();
    private final Map<Task, Set<String>> canonicalizedOutputCache = Maps.newIdentityHashMap();
    private final Map<Task, Boolean> isParallelSafeCache = Maps.newIdentityHashMap();
    private boolean tasksCancelled;
    private final boolean intraProjectParallelization;

    public DefaultTaskExecutionPlan(BuildCancellationToken cancellationToken, boolean intraProjectParallelization) {
        this.cancellationToken = cancellationToken;
        this.intraProjectParallelization = intraProjectParallelization;
        if (intraProjectParallelization) {
            LOGGER.info("intra project task parallelization is enabled");
        }
    }

    public DefaultTaskExecutionPlan(BuildCancellationToken cancellationToken) {
        this(cancellationToken, Boolean.getBoolean(INTRA_PROJECT_TOGGLE));
    }

    public void addToTaskGraph(Collection<? extends Task> tasks) {
        TaskInfo node;
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>();
        ArrayList<? extends Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        for (Task task : sortedTasks) {
            node = this.graph.addNode(task);
            if (node.isMustNotRun()) {
                this.requireWithDependencies(node);
            } else if (this.filter.isSatisfiedBy((Object)task)) {
                node.require();
            }
            this.entryTasks.add(node);
            queue.add(node);
        }
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        CachingTaskDependencyResolveContext cachingTaskDependencyResolveContext = new CachingTaskDependencyResolveContext();
        while (!queue.isEmpty()) {
            boolean filtered;
            node = (TaskInfo)queue.get(0);
            if (node.getDependenciesProcessed()) {
                queue.remove(0);
                continue;
            }
            TaskInternal task = node.getTask();
            boolean bl = filtered = !this.filter.isSatisfiedBy((Object)task);
            if (filtered) {
                queue.remove(0);
                node.dependenciesProcessed();
                node.doNotRequire();
                continue;
            }
            if (visiting.add(node)) {
                TaskInfo targetNode;
                Set<? extends Task> dependsOnTasks = cachingTaskDependencyResolveContext.getDependencies(task);
                for (Task task2 : dependsOnTasks) {
                    targetNode = this.graph.addNode(task2);
                    node.addDependencySuccessor(targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task3 : task.getFinalizedBy().getDependencies(task)) {
                    targetNode = this.graph.addNode(task3);
                    this.addFinalizerNode(node, targetNode);
                    if (visiting.contains(targetNode)) continue;
                    queue.add(0, targetNode);
                }
                for (Task task4 : task.getMustRunAfter().getDependencies(task)) {
                    targetNode = this.graph.addNode(task4);
                    node.addMustSuccessor(targetNode);
                }
                for (Task task5 : task.getShouldRunAfter().getDependencies(task)) {
                    targetNode = this.graph.addNode(task5);
                    node.addShouldSuccessor(targetNode);
                }
                if (node.isRequired()) {
                    for (TaskInfo taskInfo : node.getDependencySuccessors()) {
                        if (!this.filter.isSatisfiedBy((Object)taskInfo.getTask())) continue;
                        taskInfo.require();
                    }
                    continue;
                }
                this.tasksInUnknownState.add(node);
                continue;
            }
            queue.remove(0);
            visiting.remove(node);
            node.dependenciesProcessed();
        }
        this.resolveTasksInUnknownState();
    }

    private void resolveTasksInUnknownState() {
        ArrayList<TaskInfo> queue = new ArrayList<TaskInfo>(this.tasksInUnknownState);
        HashSet<TaskInfo> visiting = new HashSet<TaskInfo>();
        block0: while (!queue.isEmpty()) {
            TaskInfo task = (TaskInfo)queue.get(0);
            if (task.isInKnownState()) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(task)) {
                for (TaskInfo hardPredecessor : task.getDependencyPredecessors()) {
                    if (visiting.contains(hardPredecessor)) continue;
                    queue.add(0, hardPredecessor);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(task);
            task.mustNotRun();
            for (TaskInfo predecessor : task.getDependencyPredecessors()) {
                assert (predecessor.isRequired() || predecessor.isMustNotRun());
                if (!predecessor.isRequired()) continue;
                task.require();
                continue block0;
            }
        }
    }

    private void addFinalizerNode(TaskInfo node, TaskInfo finalizerNode) {
        if (this.filter.isSatisfiedBy((Object)finalizerNode.getTask())) {
            node.addFinalizer(finalizerNode);
            if (!finalizerNode.isInKnownState()) {
                finalizerNode.mustNotRun();
            }
            finalizerNode.addMustSuccessor(node);
        }
    }

    private <T> void addAllReversed(List<T> list, TreeSet<T> set) {
        List elements = CollectionUtils.toList(set);
        Collections.reverse(elements);
        list.addAll(elements);
    }

    private void requireWithDependencies(TaskInfo taskInfo) {
        if (taskInfo.isMustNotRun() && this.filter.isSatisfiedBy((Object)taskInfo.getTask())) {
            taskInfo.require();
            for (TaskInfo dependency : taskInfo.getDependencySuccessors()) {
                this.requireWithDependencies(dependency);
            }
        }
    }

    public void determineExecutionPlan() {
        ArrayList nodeQueue = Lists.newArrayList((Iterable)Iterables.transform(this.entryTasks, (Function)new Function<TaskInfo, TaskInfoInVisitingSegment>(){
            int index;

            public TaskInfoInVisitingSegment apply(TaskInfo taskInfo) {
                return new TaskInfoInVisitingSegment(taskInfo, this.index++);
            }
        }));
        int visitingSegmentCounter = nodeQueue.size();
        HashMultimap visitingNodes = HashMultimap.create();
        Stack<GraphEdge> walkedShouldRunAfterEdges = new Stack<GraphEdge>();
        Stack<TaskInfo> path = new Stack<TaskInfo>();
        HashMap<TaskInfo, Integer> planBeforeVisiting = new HashMap<TaskInfo, Integer>();
        while (!nodeQueue.isEmpty()) {
            TaskInfoInVisitingSegment taskInfoInVisitingSegment = (TaskInfoInVisitingSegment)nodeQueue.get(0);
            int currentSegment = taskInfoInVisitingSegment.visitingSegment;
            TaskInfo taskNode = taskInfoInVisitingSegment.taskInfo;
            if (taskNode.isIncludeInGraph() || this.executionPlan.containsKey(taskNode.getTask())) {
                nodeQueue.remove(0);
                this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, taskNode);
                continue;
            }
            boolean alreadyVisited = visitingNodes.containsKey((Object)taskNode);
            visitingNodes.put((Object)taskNode, (Object)currentSegment);
            if (!alreadyVisited) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, taskNode);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle((HashMultimap<TaskInfo, Integer>)visitingNodes, taskInfoInVisitingSegment);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, taskNode);
                ArrayList<TaskInfo> successors = new ArrayList<TaskInfo>();
                this.addAllSuccessorsInReverseOrder(taskNode, successors);
                for (TaskInfo successor : successors) {
                    if (visitingNodes.containsEntry((Object)successor, (Object)currentSegment)) {
                        if (!walkedShouldRunAfterEdges.empty()) {
                            GraphEdge toBeRemoved = walkedShouldRunAfterEdges.pop();
                            toBeRemoved.from.removeShouldRunAfterSuccessor(toBeRemoved.to);
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, (HashMultimap<TaskInfo, Integer>)visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle();
                    }
                    nodeQueue.add(0, new TaskInfoInVisitingSegment(successor, currentSegment));
                }
                path.push(taskNode);
                continue;
            }
            nodeQueue.remove(0);
            visitingNodes.remove((Object)taskNode, (Object)currentSegment);
            path.pop();
            this.executionPlan.put(taskNode.getTask(), taskNode);
            ArrayList finalizerTasks = new ArrayList();
            this.addAllReversed(finalizerTasks, taskNode.getFinalizers());
            for (TaskInfo finalizer : finalizerTasks) {
                if (visitingNodes.containsKey((Object)finalizer)) continue;
                nodeQueue.add(this.finalizerTaskPosition(finalizer, nodeQueue), new TaskInfoInVisitingSegment(finalizer, visitingSegmentCounter++));
            }
        }
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Stack<GraphEdge> walkedShouldRunAfterEdges, TaskInfo taskNode) {
        if (!walkedShouldRunAfterEdges.isEmpty() && walkedShouldRunAfterEdges.peek().to.equals(taskNode)) {
            walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(HashMap<TaskInfo, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        Iterator<Map.Entry<Task, TaskInfo>> executionPlanIterator = this.executionPlan.entrySet().iterator();
        for (int i = 0; i < planBeforeVisiting.get(toBeRemoved.from); ++i) {
            executionPlanIterator.next();
        }
        while (executionPlanIterator.hasNext()) {
            executionPlanIterator.next();
            executionPlanIterator.remove();
        }
    }

    private void restoreQueue(List<TaskInfoInVisitingSegment> nodeQueue, HashMultimap<TaskInfo, Integer> visitingNodes, GraphEdge toBeRemoved) {
        TaskInfoInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.taskInfo)) {
            nextInQueue = nodeQueue.get(0);
            visitingNodes.remove((Object)nextInQueue.taskInfo, (Object)nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.taskInfo)) continue;
            nodeQueue.remove(0);
        }
    }

    private void restorePath(Stack<TaskInfo> path, GraphEdge toBeRemoved) {
        TaskInfo removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void addAllSuccessorsInReverseOrder(TaskInfo taskNode, ArrayList<TaskInfo> dependsOnTasks) {
        this.addAllReversed(dependsOnTasks, taskNode.getDependencySuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getMustSuccessors());
        this.addAllReversed(dependsOnTasks, taskNode.getShouldSuccessors());
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(final HashMultimap<TaskInfo, Integer> visitingNodes, final TaskInfoInVisitingSegment taskNodeWithVisitingSegment) {
        TaskInfo taskNode = taskNodeWithVisitingSegment.taskInfo;
        Iterables.removeIf(taskNode.getShouldSuccessors(), (Predicate)new Predicate<TaskInfo>(){

            public boolean apply(TaskInfo input) {
                return visitingNodes.containsEntry((Object)input, (Object)taskNodeWithVisitingSegment.visitingSegment);
            }
        });
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(HashMap<TaskInfo, Integer> planBeforeVisiting, TaskInfo taskNode) {
        if (taskNode.getShouldSuccessors().size() > 0) {
            planBeforeVisiting.put(taskNode, this.executionPlan.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Stack<GraphEdge> walkedShouldRunAfterEdges, Stack<TaskInfo> path, TaskInfo taskNode) {
        if (!path.empty() && path.peek().getShouldSuccessors().contains(taskNode)) {
            walkedShouldRunAfterEdges.push(new GraphEdge(path.peek(), taskNode));
        }
    }

    private int finalizerTaskPosition(TaskInfo finalizer, final List<TaskInfoInVisitingSegment> nodeQueue) {
        if (nodeQueue.size() == 0) {
            return 0;
        }
        ArrayList<TaskInfo> dependsOnTasks = new ArrayList<TaskInfo>();
        dependsOnTasks.addAll(finalizer.getDependencySuccessors());
        dependsOnTasks.addAll(finalizer.getMustSuccessors());
        dependsOnTasks.addAll(finalizer.getShouldSuccessors());
        List dependsOnTaskIndexes = CollectionUtils.collect(dependsOnTasks, (Transformer)new Transformer<Integer, TaskInfo>(){

            public Integer transform(final TaskInfo dependsOnTask) {
                return Iterables.indexOf((Iterable)nodeQueue, (Predicate)new Predicate<TaskInfoInVisitingSegment>(){

                    public boolean apply(TaskInfoInVisitingSegment taskInfoInVisitingSegment) {
                        return taskInfoInVisitingSegment.taskInfo.equals(dependsOnTask);
                    }
                });
            }
        });
        return (Integer)Collections.max(dependsOnTaskIndexes) + 1;
    }

    private void onOrderingCycle() {
        CachingDirectedGraphWalker<TaskInfo, Void> graphWalker = new CachingDirectedGraphWalker<TaskInfo, Void>(new DirectedGraph<TaskInfo, Void>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Void> values, Collection<? super TaskInfo> connectedNodes) {
                connectedNodes.addAll(node.getDependencySuccessors());
                connectedNodes.addAll(node.getMustSuccessors());
            }
        });
        graphWalker.add((Iterable<TaskInfo>)this.entryTasks);
        final ArrayList firstCycle = new ArrayList(graphWalker.findCycles().get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<TaskInfo> graphRenderer = new DirectedGraphRenderer<TaskInfo>(new GraphNodeRenderer<TaskInfo>(){

            @Override
            public void renderTo(TaskInfo node, StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text(node.getTask().getPath());
            }
        }, new DirectedGraph<TaskInfo, Object>(){

            @Override
            public void getNodeValues(TaskInfo node, Collection<? super Object> values, Collection<? super TaskInfo> connectedNodes) {
                for (TaskInfo dependency : firstCycle) {
                    if (!node.getDependencySuccessors().contains(dependency) && !node.getMustSuccessors().contains(dependency)) continue;
                    connectedNodes.add(dependency);
                }
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((TaskInfo)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.graph.clear();
            this.entryTasks.clear();
            this.executionPlan.clear();
            this.failures.clear();
            this.projectsWithRunningTasks.clear();
            this.projectsWithRunningNonParallelizableTasks.clear();
            this.canonicalizedOutputCache.clear();
            this.isParallelSafeCache.clear();
            this.runningTasks.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Task> getTasks() {
        return new ArrayList<Task>(this.executionPlan.keySet());
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void useFailureHandler(TaskFailureHandler handler) {
        this.failureHandler = handler;
    }

    @Override
    public TaskInfo getTaskToExecute() {
        this.lock.lock();
        try {
            while (true) {
                if (this.cancellationToken.isCancellationRequested() && this.abortExecution()) {
                    this.tasksCancelled = true;
                }
                TaskInfo nextMatching = null;
                boolean allTasksComplete = true;
                for (TaskInfo taskInfo : this.executionPlan.values()) {
                    boolean bl = allTasksComplete = allTasksComplete && taskInfo.isComplete();
                    if (!taskInfo.isReady() || !taskInfo.allDependenciesComplete() || !this.canRunWithWithCurrentlyExecutedTasks(taskInfo)) continue;
                    nextMatching = taskInfo;
                    break;
                }
                if (allTasksComplete) {
                    Iterator<TaskInfo> i$ = null;
                    return i$;
                }
                if (nextMatching == null) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (nextMatching.allDependenciesSuccessful()) {
                    nextMatching.startExecution();
                    this.recordTaskStarted(nextMatching);
                    TaskInfo taskInfo = nextMatching;
                    return taskInfo;
                }
                nextMatching.skipExecution();
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean canRunWithWithCurrentlyExecutedTasks(TaskInfo taskInfo) {
        TaskInternal task = taskInfo.getTask();
        String projectPath = task.getProject().getPath();
        if (this.isParallelizable(task) ? this.projectsWithRunningNonParallelizableTasks.contains((Object)projectPath) : this.projectsWithRunningTasks.contains((Object)projectPath)) {
            return false;
        }
        Tuple<TaskInternal, String> overlap = this.firstTaskWithOverlappingOutput(task);
        if (overlap == null) {
            return true;
        }
        LOGGER.info("Cannot execute task " + task.getPath() + " in parallel with task " + ((TaskInternal)overlap.left).getPath() + " due to overlapping output: " + (String)overlap.right);
        return false;
    }

    private Set<String> canonicalizedOutputPaths(TaskInternal task) {
        HashSet paths = this.canonicalizedOutputCache.get(task);
        if (paths == null) {
            paths = Sets.newHashSet((Iterable)Iterables.transform((Iterable)task.getOutputs().getFiles(), (Function)new Function<File, String>(){

                public String apply(File file) {
                    String path;
                    try {
                        path = file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                    return path;
                }
            }));
            this.canonicalizedOutputCache.put(task, paths);
        }
        return paths;
    }

    @Nullable
    private Tuple<TaskInternal, String> firstTaskWithOverlappingOutput(TaskInternal candidateTask) {
        if (this.runningTasks.isEmpty()) {
            return null;
        }
        for (String candidateTaskOutputPath : this.canonicalizedOutputPaths(candidateTask)) {
            for (TaskInternal runningTask : this.runningTasks) {
                for (String runningTaskOutputPath : this.canonicalizedOutputPaths(runningTask)) {
                    if (!this.pathsOverlap(candidateTaskOutputPath, runningTaskOutputPath)) continue;
                    return Tuple.of((Object)runningTask, (Object)TextUtil.shorterOf((String)candidateTaskOutputPath, (String)runningTaskOutputPath));
                }
            }
        }
        return null;
    }

    private boolean pathsOverlap(String firstPath, String secondPath) {
        String longer;
        String shorter;
        if (firstPath.equals(secondPath)) {
            return true;
        }
        if (firstPath.length() > secondPath.length()) {
            shorter = secondPath;
            longer = firstPath;
        } else {
            shorter = firstPath;
            longer = secondPath;
        }
        return longer.startsWith(shorter + StandardSystemProperty.FILE_SEPARATOR.value());
    }

    boolean isParallelizable(TaskInternal task) {
        if (this.intraProjectParallelization) {
            Boolean safe = this.isParallelSafeCache.get(task);
            if (safe == null) {
                safe = this.detectIsParallelizable(task);
                this.isParallelSafeCache.put(task, safe);
            }
            return safe;
        }
        return false;
    }

    private boolean detectIsParallelizable(TaskInternal task) {
        if (task.getClass().isAnnotationPresent(ParallelizableTask.class)) {
            if (task.isHasCustomActions()) {
                LOGGER.info("Unable to parallelize task " + task.getPath() + " due to presence of custom actions (e.g. doFirst()/doLast())");
            } else {
                return true;
            }
        }
        return false;
    }

    private void recordTaskStarted(TaskInfo taskInfo) {
        TaskInternal task = taskInfo.getTask();
        String projectPath = task.getProject().getPath();
        if (!this.isParallelizable(task)) {
            this.projectsWithRunningNonParallelizableTasks.add((Object)projectPath);
        }
        this.projectsWithRunningTasks.add((Object)projectPath);
        this.runningTasks.add(task);
    }

    private void recordTaskCompleted(TaskInfo taskInfo) {
        TaskInternal task = taskInfo.getTask();
        String projectPath = task.getProject().getPath();
        if (!this.isParallelizable(task)) {
            this.projectsWithRunningNonParallelizableTasks.remove((Object)projectPath);
        }
        this.projectsWithRunningTasks.remove((Object)projectPath);
        this.canonicalizedOutputCache.remove(task);
        this.isParallelSafeCache.remove(task);
        this.runningTasks.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskComplete(TaskInfo taskInfo) {
        this.lock.lock();
        try {
            this.enforceFinalizerTasks(taskInfo);
            if (taskInfo.isFailed()) {
                this.handleFailure(taskInfo);
            }
            taskInfo.finishExecution();
            this.recordTaskCompleted(taskInfo);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void enforceFinalizerTasks(TaskInfo taskInfo) {
        for (TaskInfo finalizerNode : taskInfo.getFinalizers()) {
            if (!finalizerNode.isRequired() && !finalizerNode.isMustNotRun()) continue;
            this.enforceWithDependencies(finalizerNode);
        }
    }

    private void enforceWithDependencies(TaskInfo node) {
        for (TaskInfo dependencyNode : node.getDependencySuccessors()) {
            this.enforceWithDependencies(dependencyNode);
        }
        if (node.isMustNotRun() || node.isRequired()) {
            node.enforceRun();
        }
    }

    private void handleFailure(TaskInfo taskInfo) {
        Throwable executionFailure = taskInfo.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failures.add(executionFailure);
            return;
        }
        try {
            this.failureHandler.onTaskFailure(taskInfo.getTask());
            this.failures.add(taskInfo.getTaskFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failures.add(e);
        }
    }

    private boolean abortExecution() {
        boolean aborted = false;
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (!taskInfo.isRequired()) continue;
            taskInfo.skipExecution();
            aborted = true;
        }
        return aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitCompletion() {
        this.lock.lock();
        try {
            while (!this.allTasksComplete()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.rethrowFailures();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void rethrowFailures() {
        if (this.tasksCancelled) {
            this.failures.add((Throwable)((Object)new BuildCancelledException()));
        }
        if (this.failures.isEmpty()) {
            return;
        }
        if (this.failures.size() > 1) {
            throw new MultipleBuildFailures(this.failures);
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)this.failures.get(0));
    }

    private boolean allTasksComplete() {
        for (TaskInfo taskInfo : this.executionPlan.values()) {
            if (taskInfo.isComplete()) continue;
            return false;
        }
        return true;
    }

    private static class RethrowingFailureHandler
    implements TaskFailureHandler {
        private RethrowingFailureHandler() {
        }

        public void onTaskFailure(Task task) {
            task.getState().rethrowFailure();
        }
    }

    private static class TaskInfoInVisitingSegment {
        private final TaskInfo taskInfo;
        private final int visitingSegment;

        private TaskInfoInVisitingSegment(TaskInfo taskInfo, int visitingSegment) {
            this.taskInfo = taskInfo;
            this.visitingSegment = visitingSegment;
        }
    }

    private static class GraphEdge {
        private final TaskInfo from;
        private final TaskInfo to;

        private GraphEdge(TaskInfo from, TaskInfo to) {
            this.from = from;
            this.to = to;
        }
    }
}

