/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.execution.TaskSelectionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolver {
    @Nullable
    public TaskSelectionResult selectWithName(String name, Project project, boolean includeSubProjects) {
        if (!includeSubProjects) {
            TaskInternal task = (TaskInternal)project.getTasks().findByName(name);
            if (task != null) {
                return new FixedTaskSelectionResult(Collections.singleton(task));
            }
        } else {
            LinkedHashSet<Task> tasks = new LinkedHashSet<Task>();
            new MultiProjectTaskSelectionResult(name, project).collectTasks(tasks);
            if (!tasks.isEmpty()) {
                return new FixedTaskSelectionResult(tasks);
            }
        }
        return null;
    }

    public Map<String, TaskSelectionResult> selectAll(Project project, boolean includeSubProjects) {
        LinkedHashMap<String, TaskSelectionResult> selected = new LinkedHashMap<String, TaskSelectionResult>();
        if (!includeSubProjects) {
            for (String taskName : project.getTasks().getNames()) {
                selected.put(taskName, new SingleProjectTaskSelectionResult(taskName, project.getTasks()));
            }
        } else {
            LinkedHashSet<String> taskNames = new LinkedHashSet<String>();
            this.collectTaskNames(project, taskNames);
            for (String taskName : taskNames) {
                selected.put(taskName, new MultiProjectTaskSelectionResult(taskName, project));
            }
        }
        return selected;
    }

    private void collectTaskNames(Project project, Set<String> result) {
        result.addAll(project.getTasks().getNames());
        for (Project subProject : project.getChildProjects().values()) {
            this.collectTaskNames(subProject, result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final Project project;
        private final String taskName;

        MultiProjectTaskSelectionResult(String taskName, Project project) {
            this.project = project;
            this.taskName = taskName;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            this.collect(this.project, tasks);
        }

        private void collect(Project project, Collection<? super Task> tasks) {
            TaskInternal task = (TaskInternal)project.getTasks().findByName(this.taskName);
            if (task != null) {
                tasks.add(task);
                if (task.getImpliesSubProjects()) {
                    return;
                }
            }
            for (Project subProject : project.getChildProjects().values()) {
                this.collect(subProject, tasks);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleProjectTaskSelectionResult
    implements TaskSelectionResult {
        private final TaskContainer taskContainer;
        private final String taskName;

        SingleProjectTaskSelectionResult(String taskName, TaskContainer tasksContainer) {
            this.taskContainer = tasksContainer;
            this.taskName = taskName;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.add((Task)this.taskContainer.getByName(this.taskName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedTaskSelectionResult
    implements TaskSelectionResult {
        private final Collection<Task> tasks;

        FixedTaskSelectionResult(Collection<Task> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void collectTasks(Collection<? super Task> tasks) {
            tasks.addAll(this.tasks);
        }
    }
}

