/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.InputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NestedBeanPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessingTaskFactory
implements ITaskFactory {
    private final ITaskFactory taskFactory;
    private final Map<Class, TaskClassInfo> classInfos;
    private final Transformer<Iterable<File>, Object> filePropertyTransformer = new Transformer<Iterable<File>, Object>(){

        public Iterable<File> transform(Object original) {
            File file = (File)original;
            return file == null ? Collections.emptyList() : Collections.singleton(file);
        }
    };
    private final Transformer<Iterable<File>, Object> iterableFilePropertyTransformer = new Transformer<Iterable<File>, Object>(){

        public Iterable<File> transform(Object original) {
            return original != null ? (Iterable)original : Collections.emptyList();
        }
    };
    private final List<? extends PropertyAnnotationHandler> handlers = Arrays.asList(new InputFilePropertyAnnotationHandler(), new InputDirectoryPropertyAnnotationHandler(), new InputFilesPropertyAnnotationHandler(), new OutputFilePropertyAnnotationHandler(OutputFile.class, this.filePropertyTransformer), new OutputFilePropertyAnnotationHandler(OutputFiles.class, this.iterableFilePropertyTransformer), new OutputDirectoryPropertyAnnotationHandler(OutputDirectory.class, this.filePropertyTransformer), new OutputDirectoryPropertyAnnotationHandler(OutputDirectories.class, this.iterableFilePropertyTransformer), new InputPropertyAnnotationHandler(), new NestedBeanPropertyAnnotationHandler());
    private final ValidationAction notNullValidator = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            if (value == null) {
                messages.add(String.format("No value has been specified for property '%s'.", propertyName));
            }
        }
    };

    public AnnotationProcessingTaskFactory(ITaskFactory taskFactory) {
        this.taskFactory = taskFactory;
        this.classInfos = new HashMap<Class, TaskClassInfo>();
    }

    private AnnotationProcessingTaskFactory(Map<Class, TaskClassInfo> classInfos, ITaskFactory taskFactory) {
        this.classInfos = classInfos;
        this.taskFactory = taskFactory;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new AnnotationProcessingTaskFactory(this.classInfos, this.taskFactory.createChild(project, instantiator));
    }

    @Override
    public TaskInternal createTask(Map<String, ?> args) {
        TaskInternal task = this.taskFactory.createTask(args);
        TaskClassInfo taskClassInfo = this.getTaskClassInfo(task.getClass());
        if (taskClassInfo.incremental) {
            task.getOutputs().upToDateWhen((Spec<? super Task>)new Spec<Task>(){

                public boolean isSatisfiedBy(Task element) {
                    return true;
                }
            });
        }
        for (Factory<Action<Task>> actionFactory : taskClassInfo.taskActions) {
            task.prependParallelSafeAction((Action<? super Task>)((Action)actionFactory.create()));
        }
        if (taskClassInfo.validator != null) {
            task.prependParallelSafeAction(taskClassInfo.validator);
            taskClassInfo.validator.addInputsAndOutputs(task);
        }
        return task;
    }

    private TaskClassInfo getTaskClassInfo(Class<? extends Task> type) {
        TaskClassInfo taskClassInfo = this.classInfos.get(type);
        if (taskClassInfo == null) {
            taskClassInfo = new TaskClassInfo();
            this.findTaskActions(type, taskClassInfo);
            Validator validator = new Validator();
            validator.attachActions(null, type);
            if (!validator.properties.isEmpty()) {
                taskClassInfo.validator = validator;
            }
            this.classInfos.put(type, taskClassInfo);
        }
        return taskClassInfo;
    }

    private void findTaskActions(Class<? extends Task> type, TaskClassInfo taskClassInfo) {
        HashSet<String> methods = new HashSet<String>();
        for (Class<? extends Task> current = type; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                this.attachTaskAction(method, taskClassInfo, methods);
            }
        }
    }

    private void attachTaskAction(Method method, TaskClassInfo taskClassInfo, Collection<String> processedMethods) {
        if (method.getAnnotation(TaskAction.class) == null) {
            return;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on static method %s.%s().", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() as this method takes multiple parameters.", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        if (parameterTypes.length == 1) {
            if (!parameterTypes[0].equals(IncrementalTaskInputs.class)) {
                throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() because %s is not a valid parameter to an action method.", method.getDeclaringClass().getSimpleName(), method.getName(), parameterTypes[0]));
            }
            if (taskClassInfo.incremental) {
                throw new GradleException(String.format("Cannot have multiple @TaskAction methods accepting an %s parameter.", IncrementalTaskInputs.class.getSimpleName()));
            }
            taskClassInfo.incremental = true;
        }
        if (processedMethods.contains(method.getName())) {
            return;
        }
        taskClassInfo.taskActions.add(this.createActionFactory(method, parameterTypes));
        processedMethods.add(method.getName());
    }

    private Factory<Action<Task>> createActionFactory(final Method method, final Class<?>[] parameterTypes) {
        return new Factory<Action<Task>>(){

            public Action<Task> create() {
                if (parameterTypes.length == 1) {
                    return new IncrementalTaskAction(method);
                }
                return new StandardTaskAction(method);
            }
        };
    }

    private static boolean isGetter(Method method) {
        return (method.getName().startsWith("get") && method.getReturnType() != Void.TYPE || method.getName().startsWith("is") && method.getReturnType().equals(Boolean.TYPE)) && method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyInfo
    implements PropertyActionContext {
        private static final ValidationAction NO_OP_VALIDATION_ACTION = new ValidationAction(){

            @Override
            public void validate(String propertyName, Object value, Collection<String> messages) {
            }
        };
        private static final PropertyValue NO_OP_VALUE = new PropertyValue(){

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public void checkNotNull(Collection<String> messages) {
            }

            @Override
            public void checkValid(Collection<String> messages) {
            }
        };
        private static final UpdateAction NO_OP_CONFIGURATION_ACTION = new UpdateAction(){

            @Override
            public void update(TaskInternal task, Callable<Object> futureValue) {
            }
        };
        private final Validator validator;
        private final PropertyInfo parent;
        private final String propertyName;
        private final Method method;
        private ValidationAction validationAction = NO_OP_VALIDATION_ACTION;
        private ValidationAction notNullValidator = NO_OP_VALIDATION_ACTION;
        private UpdateAction configureAction = NO_OP_CONFIGURATION_ACTION;
        public boolean required;
        private final Class<?> type;

        private PropertyInfo(Class<?> type, Validator validator, PropertyInfo parent, String propertyName, Method method) {
            this.type = type;
            this.validator = validator;
            this.parent = parent;
            this.propertyName = propertyName;
            this.method = method;
        }

        public String toString() {
            return this.propertyName;
        }

        @Override
        public String getName() {
            return this.propertyName;
        }

        @Override
        public Class<?> getType() {
            return this.method.getReturnType();
        }

        @Override
        public Class<?> getInstanceVariableType() {
            Class<?> currentType = this.type;
            while (!currentType.equals(Object.class)) {
                try {
                    return currentType.getDeclaredField(this.propertyName).getType();
                }
                catch (NoSuchFieldException e) {
                    currentType = currentType.getSuperclass();
                }
            }
            return null;
        }

        @Override
        public AnnotatedElement getTarget() {
            return this.method;
        }

        @Override
        public void setValidationAction(ValidationAction action) {
            this.validationAction = action;
        }

        @Override
        public void setConfigureAction(UpdateAction action) {
            this.configureAction = action;
        }

        public void setNotNullValidator(ValidationAction notNullValidator) {
            this.notNullValidator = notNullValidator;
        }

        @Override
        public void attachActions(Class<?> type) {
            this.validator.attachActions(this, type);
        }

        public PropertyValue getValue(Object rootObject) {
            Object bean = rootObject;
            if (this.parent != null) {
                PropertyValue parentValue = this.parent.getValue(rootObject);
                if (parentValue.getValue() == null) {
                    return NO_OP_VALUE;
                }
                bean = parentValue.getValue();
            }
            final Object finalBean = bean;
            final Object value = DeprecationLogger.whileDisabled(new Factory<Object>(){

                public Object create() {
                    return JavaReflectionUtil.method((Object)finalBean, Object.class, (Method)PropertyInfo.this.method).invoke(finalBean, new Object[0]);
                }
            });
            return new PropertyValue(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public void checkNotNull(Collection<String> messages) {
                    PropertyInfo.this.notNullValidator.validate(PropertyInfo.this.propertyName, value, messages);
                }

                @Override
                public void checkValid(Collection<String> messages) {
                    if (value != null) {
                        PropertyInfo.this.validationAction.validate(PropertyInfo.this.propertyName, value, messages);
                    }
                }
            };
        }

        public void attachActions(PropertyAnnotationHandler handler) {
            handler.attachActions(this);
            this.required = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PropertyValue {
        public Object getValue();

        public void checkNotNull(Collection<String> var1);

        public void checkValid(Collection<String> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Validator
    implements Action<Task>,
    TaskValidator {
        private Set<PropertyInfo> properties = new LinkedHashSet<PropertyInfo>();

        private Validator() {
        }

        public void addInputsAndOutputs(final TaskInternal task) {
            task.addValidator(this);
            for (final PropertyInfo property : this.properties) {
                Callable<Object> futureValue = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return property.getValue(task).getValue();
                    }
                };
                property.configureAction.update(task, futureValue);
            }
        }

        public void execute(Task task) {
        }

        @Override
        public void validate(TaskInternal task, Collection<String> messages) {
            ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
            for (PropertyInfo property : this.properties) {
                propertyValues.add(property.getValue(task));
            }
            for (PropertyValue propertyValue : propertyValues) {
                propertyValue.checkNotNull(messages);
            }
            for (PropertyValue propertyValue : propertyValues) {
                propertyValue.checkValid(messages);
            }
        }

        public void attachActions(PropertyInfo parent, Class<?> type) {
            Class<?> superclass = type.getSuperclass();
            if (!(superclass == null || superclass.equals(ConventionTask.class) || superclass.equals(DefaultTask.class) || superclass.equals(AbstractTask.class) || superclass.equals(Object.class))) {
                this.attachActions(parent, superclass);
            }
            for (Method method : type.getDeclaredMethods()) {
                String fieldName;
                if (!AnnotationProcessingTaskFactory.isGetter(method)) continue;
                String name = method.getName();
                int prefixLength = name.startsWith("is") ? 2 : 3;
                String propertyName = fieldName = StringUtils.uncapitalize((String)name.substring(prefixLength));
                if (parent != null) {
                    propertyName = parent.getName() + '.' + propertyName;
                }
                PropertyInfo propertyInfo = new PropertyInfo(type, this, parent, propertyName, method);
                this.attachValidationActions(propertyInfo, fieldName);
                if (!propertyInfo.required) continue;
                this.properties.add(propertyInfo);
            }
        }

        private void attachValidationActions(PropertyInfo propertyInfo, String fieldName) {
            for (PropertyAnnotationHandler handler : AnnotationProcessingTaskFactory.this.handlers) {
                this.attachValidationAction(handler, propertyInfo, fieldName);
            }
        }

        private void attachValidationAction(PropertyAnnotationHandler handler, PropertyInfo propertyInfo, String fieldName) {
            Method method = propertyInfo.method;
            Class<? extends Annotation> annotationType = handler.getAnnotationType();
            AccessibleObject annotationTarget = null;
            if (method.getAnnotation(annotationType) != null) {
                annotationTarget = method;
            } else {
                try {
                    Field field = method.getDeclaringClass().getDeclaredField(fieldName);
                    if (field.getAnnotation(annotationType) != null) {
                        annotationTarget = field;
                    }
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            if (annotationTarget == null) {
                return;
            }
            Optional optional = annotationTarget.getAnnotation(Optional.class);
            if (optional == null) {
                propertyInfo.setNotNullValidator(AnnotationProcessingTaskFactory.this.notNullValidator);
            }
            propertyInfo.attachActions(handler);
        }
    }

    private static class TaskClassInfo {
        public Validator validator;
        public List<Factory<Action<Task>>> taskActions = new ArrayList<Factory<Action<Task>>>();
        public boolean incremental;

        private TaskClassInfo() {
        }
    }

    public static class IncrementalTaskAction
    extends StandardTaskAction
    implements ContextAwareTaskAction {
        private TaskArtifactState taskArtifactState;

        public IncrementalTaskAction(Method method) {
            super(method);
        }

        public void contextualise(TaskExecutionContext context) {
            this.taskArtifactState = context == null ? null : context.getTaskArtifactState();
        }

        protected void doExecute(Task task, String methodName) {
            JavaReflectionUtil.method((Object)task, Object.class, (String)methodName, (Class[])new Class[]{IncrementalTaskInputs.class}).invoke((Object)task, new Object[]{this.taskArtifactState.getInputChanges()});
            this.taskArtifactState = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandardTaskAction
    implements Action<Task> {
        private final Method method;

        public StandardTaskAction(Method method) {
            this.method = method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Task task) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.method.getDeclaringClass().getClassLoader());
            try {
                this.doExecute(task, this.method.getName());
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        protected void doExecute(Task task, String methodName) {
            JavaReflectionUtil.method((Object)task, Object.class, (String)methodName, (Class[])new Class[0]).invoke((Object)task, new Object[0]);
        }
    }
}

