/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.ImperativeOnlyPluginApplicator;
import org.gradle.api.internal.plugins.PluginApplicator;
import org.gradle.api.plugins.PluginAware;
import org.gradle.model.internal.inspect.ModelRuleInspector;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.model.internal.inspect.RuleSourceDependencies;
import org.gradle.model.internal.registry.ModelRegistryScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesCapablePluginApplicator<T extends ModelRegistryScope & PluginAware>
implements PluginApplicator {
    private final ModelRuleInspector inspector;
    private final T target;
    private final ModelRuleSourceDetector modelRuleSourceDetector;
    private final PluginApplicator imperativeApplicator;

    public RulesCapablePluginApplicator(T target, ModelRuleInspector inspector, ModelRuleSourceDetector modelRuleSourceDetector) {
        this.target = target;
        this.inspector = inspector;
        this.modelRuleSourceDetector = modelRuleSourceDetector;
        this.imperativeApplicator = new ImperativeOnlyPluginApplicator<T>(target);
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        this.imperativeApplicator.applyImperative(pluginId, plugin);
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        for (Class source : this.modelRuleSourceDetector.getDeclaredSources(clazz)) {
            this.inspector.inspect(source, this.target.getModelRegistry(), new RuleSourceDependencies(){

                public void add(Class<?> source) {
                    ((PluginAware)RulesCapablePluginApplicator.this.target).getPluginManager().apply(source);
                }
            });
        }
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin) {
        this.applyImperative(pluginId, plugin);
        this.applyRules(pluginId, plugin.getClass());
    }
}

