/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PotentialPlugin;
import org.gradle.internal.Cast;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class PluginInspector {
    private final ModelRuleSourceDetector modelRuleSourceDetector;

    public PluginInspector(ModelRuleSourceDetector modelRuleSourceDetector) {
        this.modelRuleSourceDetector = modelRuleSourceDetector;
    }

    public <T> PotentialPlugin<T> inspect(Class<T> type) {
        boolean implementsInterface = Plugin.class.isAssignableFrom(type);
        boolean hasRules = this.modelRuleSourceDetector.hasModelSources(type);
        if (implementsInterface) {
            Class<T> cast = type;
            return (PotentialPlugin)Cast.uncheckedCast(this.toImperative(cast, hasRules));
        }
        if (hasRules) {
            return new PotentialPureRuleSourceClassPlugin<T>(type);
        }
        return new PotentialUnknownTypePlugin<T>(type);
    }

    private <T extends Plugin<?>> PotentialPlugin<T> toImperative(Class<T> type, boolean hasRules) {
        if (hasRules) {
            return new PotentialHybridImperativeAndRulesPlugin<T>(type);
        }
        return new PotentialImperativeClassPlugin<T>(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PotentialUnknownTypePlugin<T>
    implements PotentialPlugin<T> {
        private final Class<T> clazz;

        public PotentialUnknownTypePlugin(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<T> asClass() {
            return this.clazz;
        }

        @Override
        public boolean isImperative() {
            return false;
        }

        @Override
        public boolean isHasRules() {
            return false;
        }

        @Override
        public PotentialPlugin.Type getType() {
            return PotentialPlugin.Type.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PotentialPureRuleSourceClassPlugin<T>
    implements PotentialPlugin<T> {
        private final Class<T> clazz;

        public PotentialPureRuleSourceClassPlugin(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<T> asClass() {
            return this.clazz;
        }

        @Override
        public boolean isImperative() {
            return false;
        }

        @Override
        public PotentialPlugin.Type getType() {
            return PotentialPlugin.Type.PURE_RULE_SOURCE_CLASS;
        }

        @Override
        public boolean isHasRules() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PotentialHybridImperativeAndRulesPlugin<T extends Plugin<?>>
    implements PotentialPlugin<T> {
        private final Class<T> clazz;

        public PotentialHybridImperativeAndRulesPlugin(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<T> asClass() {
            return this.clazz;
        }

        @Override
        public boolean isImperative() {
            return true;
        }

        @Override
        public boolean isHasRules() {
            return true;
        }

        @Override
        public PotentialPlugin.Type getType() {
            return PotentialPlugin.Type.HYBRID_IMPERATIVE_AND_RULES_CLASS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PotentialImperativeClassPlugin<T extends Plugin<?>>
    implements PotentialPlugin<T> {
        private final Class<T> clazz;

        public PotentialImperativeClassPlugin(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<T> asClass() {
            return this.clazz;
        }

        @Override
        public boolean isImperative() {
            return true;
        }

        @Override
        public PotentialPlugin.Type getType() {
            return PotentialPlugin.Type.IMPERATIVE_CLASS;
        }

        @Override
        public boolean isHasRules() {
            return false;
        }
    }
}

