/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.primitives.Bytes;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.hash.DefaultHasher;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshot;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshotter;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashClassPathSnapshotter
implements ClassPathSnapshotter {
    private final Hasher hasher = new DefaultHasher();

    @Override
    public ClassPathSnapshot snapshot(ClassPath classPath) {
        LinkedList<String> visitedFilePaths = new LinkedList<String>();
        LinkedHashSet<File> visitedDirs = new LinkedHashSet<File>();
        byte[] combinedHash = new byte[]{};
        List cpFiles = classPath.getAsFiles();
        combinedHash = this.hash(visitedFilePaths, visitedDirs, combinedHash, cpFiles.toArray(new File[cpFiles.size()]));
        return new ClassPathSnapshotImpl(visitedFilePaths, combinedHash);
    }

    private byte[] hash(List<String> visitedFilePaths, Set<File> visitedDirs, byte[] combinedHash, File[] toHash) {
        for (File file : toHash) {
            if ((file = GFileUtils.canonicalise(file)).isDirectory()) {
                if (!visitedDirs.add(file)) continue;
                combinedHash = this.hash(visitedFilePaths, visitedDirs, combinedHash, file.listFiles());
                continue;
            }
            if (!file.isFile()) continue;
            visitedFilePaths.add(file.getAbsolutePath());
            combinedHash = Bytes.concat((byte[][])new byte[][]{combinedHash, this.hasher.hash(file)});
        }
        return combinedHash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassPathSnapshotImpl
    implements ClassPathSnapshot {
        private final List<String> files;
        private final byte[] combinedHash;

        public ClassPathSnapshotImpl(List<String> files, byte[] combinedHash) {
            assert (files != null);
            assert (combinedHash != null);
            this.files = files;
            this.combinedHash = combinedHash;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassPathSnapshotImpl)) {
                return false;
            }
            ClassPathSnapshotImpl that = (ClassPathSnapshotImpl)o;
            return this.files.equals(that.files) && Arrays.equals(this.combinedHash, that.combinedHash);
        }

        @Override
        public int hashCode() {
            int result = this.files.hashCode();
            result = 31 * result + Arrays.hashCode(this.combinedHash);
            return result;
        }
    }
}

