/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.base.Objects;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshot;
import org.gradle.api.internal.initialization.loadercache.ClassPathSnapshotter;
import org.gradle.api.internal.initialization.loadercache.FileClassPathSnapshotter;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderCache
implements ClassLoaderCache {
    private final Map<Key, ClassLoader> storage;
    private final Map<ClassLoaderId, Key> idCache = new HashMap<ClassLoaderId, Key>();
    final ClassPathSnapshotter snapshotter;
    private final Object lock = new Object();

    public int getSize() {
        return this.storage.size();
    }

    public DefaultClassLoaderCache(Map<Key, ClassLoader> storage) {
        this(storage, new FileClassPathSnapshotter());
    }

    public DefaultClassLoaderCache(Map<Key, ClassLoader> storage, ClassPathSnapshotter snapshotter) {
        this.storage = storage;
        this.snapshotter = snapshotter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader get(ClassLoaderId id, ClassPath classPath, ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec) {
        ClassPathSnapshot s = this.snapshotter.snapshot(classPath);
        Key key = new Key(parent, s, filterSpec);
        Object object = this.lock;
        synchronized (object) {
            this.invalidateStaleEntries(id, key);
            ClassLoader existingLoader = this.storage.get(key);
            if (existingLoader != null) {
                this.idCache.put(id, key);
                return existingLoader;
            }
            URLClassLoader newLoader = filterSpec == null ? new URLClassLoader(classPath.getAsURLArray(), parent) : new FilteringClassLoader(this.get(id, classPath, parent, null), filterSpec);
            this.storage.put(key, newLoader);
            return newLoader;
        }
    }

    private void invalidateStaleEntries(ClassLoaderId id, Key key) {
        Key existingKey = this.idCache.get(id);
        if (existingKey == null) {
            this.idCache.put(id, key);
        } else if (!existingKey.equals(key)) {
            this.idCache.put(id, key);
            this.storage.remove(existingKey);
        }
    }

    public static class Key {
        private final ClassLoader parent;
        private final ClassPathSnapshot classPathSnapshot;
        private final FilteringClassLoader.Spec filterSpec;

        private Key(ClassLoader parent, ClassPathSnapshot classPathSnapshot, FilteringClassLoader.Spec filterSpec) {
            this.parent = parent;
            this.classPathSnapshot = classPathSnapshot;
            this.filterSpec = filterSpec;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.classPathSnapshot.equals(key.classPathSnapshot)) {
                return false;
            }
            if (this.filterSpec != null ? !this.filterSpec.equals((Object)key.filterSpec) : key.filterSpec != null) {
                return false;
            }
            return Objects.equal((Object)this.parent, (Object)key.parent);
        }

        public int hashCode() {
            int result = this.parent == null ? 0 : this.parent.hashCode();
            result = 31 * result + this.classPathSnapshot.hashCode();
            result = 31 * result + (this.filterSpec != null ? this.filterSpec.hashCode() : 0);
            return result;
        }
    }
}

